#include <xparameters.h>
#include <xio.h>
#include "udp/udp.h"

void ApplicationInit()
{
	//Clear the LEDs and the seven-segment display.
	XIo_Out8(XPAR_LOGSYS_PLB_CPLD_IF_0_BASEADDR + 0x00, 0x00);
	XIo_Out8(XPAR_LOGSYS_PLB_CPLD_IF_0_BASEADDR + 0x01, 0x00);
	XIo_Out8(XPAR_LOGSYS_PLB_CPLD_IF_0_BASEADDR + 0x02, 0x00);
}


void ProcessUDPData(pudp_conn conn, void *data, unsigned long *dataLength)
{
	unsigned char *appdata = (unsigned char *)data;
	unsigned long size = *dataLength;

	//Check the data length and the destination port.
	if ((size < 1) || (size > 2) || (conn->destport != 1234))
	{
		*dataLength = 0;
		return;
	}

	//Examine the command.
	switch (appdata[0])
	{
	    case 0:
	    	//Write the received data to the LEDs.
	    	XIo_Out8(XPAR_LOGSYS_PLB_CPLD_IF_0_BASEADDR + 0x00, appdata[1]);
	    	*dataLength = 0;
	    	break;
	    case 1:
	    	//Read the state of the switches.
	    	appdata[0] = XIo_In8(XPAR_LOGSYS_PLB_CPLD_IF_0_BASEADDR + 0x04);
	    	appdata[1] = 0x00;
	    	*dataLength = 2;
	    	break;
	    default:
	    	*dataLength = 0;
	    	break;
	}
}

