//******************************************************************************
//* Header file for the 'ethernet interface.c'.                                *
//* Written by   : Tamas Raikovich (rtamas@mit.bme.hu)                         *
//* Version      : 1.0                                                         *
//* Last modified: 06/24/2010                                                  *
//******************************************************************************
#ifndef ETHERNET_INTERFACE_H_
#define ETHERNET_INTERFACE_H_

#include "xio.h"
#include "enc424j600_registers.h"

//*****************************************************************************
//* Macros for accessing the Ethernet interface peripheral registers.         *
//*****************************************************************************
#define EncSetSramEnHighLength(baseaddr, value)  XIo_Out8((baseaddr), (unsigned char)((value) & 0x0f))
#define EncSetSramEnLowLength(baseaddr, value)   XIo_Out8((baseaddr) + 0x01, (unsigned char)((value) & 0x0f))
#define EncEnableInterrupts(baseaddr)            XIo_Out8((baseaddr) + 0x02, 0x01)
#define EncDisableInterrupts(baseaddr)           XIo_Out8((baseaddr) + 0x02, 0x00)

#define EncReadSramEnHighLength(baseaddr)        XIo_In8((baseaddr))
#define EncReadSramEnLowLength(baseaddr)         XIo_In8((baseaddr) + 0x01)
#define EncReadInterruptEnable(baseaddr)         XIo_In8((baseaddr) + 0x02)


//*****************************************************************************
//* 8-bit SFR operations.                                                     *
//*****************************************************************************
#define EncWriteReg8(mem_baseaddr, reg, value)      XIo_Out8((mem_baseaddr) + ((reg) & REG_ADDR_MASK), (unsigned char)(value))
#define EncReadReg8(mem_baseaddr, reg)              XIo_In8((mem_baseaddr) + ((reg) & REG_ADDR_MASK))
#define EncSetRegBits8(mem_baseaddr, reg, mask)     XIo_Out8((mem_baseaddr) + (((reg) + BITS_SET) & REG_ADDR_MASK), (unsigned char)(mask))
#define EncClearRegBits8(mem_baseaddr, reg, mask)   XIo_Out8((mem_baseaddr) + (((reg) + BITS_CLR) & REG_ADDR_MASK), (unsigned char)(mask))


//*****************************************************************************
//* 16-bit SFR operations.                                                    *
//*****************************************************************************
void           EncWriteReg16(unsigned long mem_baseaddr, unsigned long reg, unsigned short value);
unsigned short EncReadReg16(unsigned long mem_baseaddr, unsigned long reg);
void           EncSetRegBits16(unsigned long mem_baseaddr, unsigned long reg, unsigned short mask);
void           EncClearRegBits16(unsigned long mem_baseaddr, unsigned long reg, unsigned short mask);


//*****************************************************************************
//* SRAM operations.                                                          *
//*****************************************************************************
#define SRAM_GP_BUFFER      EGPDATA
#define SRAM_RX_BUFFER      ERXDATA
#define SRAM_UD_BUFFER      EUDADATA

#define EncWriteSram8(mem_baseaddr, buffer, value)  XIo_Out8((mem_baseaddr) + ((buffer) & REG_ADDR_MASK), (unsigned char)(value))
#define EncWriteSram16(mem_baseaddr, buffer, value) XIo_Out16((mem_baseaddr) + ((buffer) & REG_ADDR_MASK), (unsigned short)(value))
#define EncWriteSram32(mem_baseaddr, buffer, value) XIo_Out32((mem_baseaddr) + ((buffer) & REG_ADDR_MASK), (unsigned long)(value))
#define EncReadSram8(mem_baseaddr, buffer)          XIo_In8((mem_baseaddr) + ((buffer) & REG_ADDR_MASK))
#define EncReadSram16(mem_baseaddr, buffer)         XIo_In16((mem_baseaddr) + ((buffer) & REG_ADDR_MASK))
#define EncReadSram32(mem_baseaddr, buffer)         XIo_In32((mem_baseaddr) + ((buffer) & REG_ADDR_MASK))

void    EncCopyToSram(unsigned long mem_baseaddr, unsigned long buffer, void *src, unsigned long len);
void    EncCopyFromSram(unsigned long mem_baseaddr, unsigned long buffer, void *dst, unsigned long len);


#endif /*ETHERNET_INTERFACE_H_*/
