////////////////////////////////////////////////////////////////////////////////
/// @file dhcp_client.h
/// Header file for the DHCP client functions.
///
/// @author  Tamas Raikovich
/// @version 1.0
/// @date    2012.01.21.
////////////////////////////////////////////////////////////////////////////////
#ifndef DHCP_CLIENT_H_
#define DHCP_CLIENT_H_

#include "netif.h"
#include "timer.h"


////////////////////////////////////////////////////////////////////////////////
///@name DHCP client and server UDP ports.
///@{
////////////////////////////////////////////////////////////////////////////////
#define DHCPC_SERVER_PORT  67
#define DHCPC_CLIENT_PORT  68
///@}


////////////////////////////////////////////////////////////////////////////////
///@name DHCP client states.
///@{
////////////////////////////////////////////////////////////////////////////////
#define DHCP_STATE_DISCOVER             0
#define DHCP_STATE_OFFER_RECEIVED       1
#define DHCP_STATE_CONFIG_RECEIVED      2
///@}


////////////////////////////////////////////////////////////////////////////////
///@name DHCP client event flags for the state machine.
///@{
////////////////////////////////////////////////////////////////////////////////
#define DHCP_FLAG_NEW_DATA              (1 << 0)
#define DHCP_FLAG_TIMER                 (1 << 1)
///@}


////////////////////////////////////////////////////////////////////////////////
/// DHCP data object structure.
////////////////////////////////////////////////////////////////////////////////
typedef struct _dhcp_state
{
    unsigned char state;                ///< Current state of the DHCP state machine.
    timer         tmr;                  ///< Timer object.
    unsigned long ticks;                ///< Timer interval.
    unsigned char servermac[6];         ///< MAC address of the DHCP server.
    unsigned char serverid[4];          ///< IP address of the DHCP server.
    unsigned long lease_time;           ///< IP address lease time in seconds.
    unsigned char ipaddr[4];            ///< IP address of the client.
    unsigned char netmask[4];           ///< Netmask.
    unsigned char dnsaddr[4];           ///< IP address of the DNS server.
    unsigned char default_router[4];    ///< IP address of the default router.
} dhcp_state, *pdhcp_state;


#endif /* DHCP_CLIENT_H_ */

