//******************************************************************************
//* SPI test application.                                                      *
//******************************************************************************
#include <xparameters.h>
#include <stdio.h>
#include "spi\spi.h"
#include "lcd\lcd.h"


//******************************************************************************
//* Reads the device ID of the SPI serial FLASH.                               *
//******************************************************************************
void FLASHTest()
{
    unsigned char data[3];

    xil_printf("Reading the FLASH device ID...");

    SPISelect(SPI_DEVICE_FLASH, 12500000);
    SPIReadWriteByte(0x9f);
    SPIReadBytes(data, 3, 0x00);
    SPIDeselect();

    xil_printf("0x%02x ", data[0]);
    xil_printf("0x%02x ", data[1]);
    xil_printf("0x%02x ", data[2]);
    xil_printf("\r\n");
}


//******************************************************************************
//* Draws an image to the LCD display.                                         *
//******************************************************************************
void LCDTest()
{
    xil_printf("LCD display test...");
    LCDDrawTestImage();
    xil_printf("Done\r\n");
}


//******************************************************************************
//* Main function.                                                             *
//******************************************************************************
int main()
{
    FLASHTest();
    LCDTest();
    xil_printf("\r\n");

    return 0;
}

