/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *  STM32 USART1 (PA9, PA10)
  ******************************************************************************
  */

#include "main.h"
#include <stdio.h>

#include "stm32f4xx_ll_gpio.h"
#include "stm32f4xx_ll_bus.h"
#include "stm32f4xx_ll_usart.h"

#define TERM_RED "\e[31m"
#define TERM_GREEN "\e[32m"
#define TERM_YELLOW "\e[33m"
#define TERM_BLUE "\e[34m"
#define TERM_MAGENTA "\e[35m"
#define TERM_CYAN "\e[36m"
#define TERM_BRED "\e[91m"
#define TERM_BGREEN "\e[92m"
#define TERM_BYELLOW "\e[93m"
#define TERM_BBLUE "\e[94m"
#define TERM_BMAGENTA "\e[95m"
#define TERM_BCYAN "\e[96m"
#define TERM_DEFAULT "\e[37m"


void SystemClock_Config(void);
/* USER CODE BEGIN PFP */
int __io_putchar(int ch)
{
	while(LL_USART_IsActiveFlag_TXE(USART1) == 0);

	LL_USART_TransmitData8  (USART1,ch);


	return 0;
}
/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
	volatile int i;
	LL_GPIO_InitTypeDef  GPIO_InitStruct;

	LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOG);
	LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA);

	GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
	GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
	GPIO_InitStruct.Pin = LL_GPIO_PIN_13;
	LL_GPIO_Init  (GPIOG,&GPIO_InitStruct);

	GPIO_InitStruct.Pin = LL_GPIO_PIN_14;
	LL_GPIO_Init  (GPIOG,&GPIO_InitStruct);

	GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
	GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
	GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_HIGH;
	GPIO_InitStruct.Pin = LL_GPIO_PIN_9;
	GPIO_InitStruct.Alternate = LL_GPIO_AF_7;
	LL_GPIO_Init  (GPIOA,&GPIO_InitStruct);

	GPIO_InitStruct.OutputType = LL_GPIO_MODE_INPUT;
	GPIO_InitStruct.Pin = LL_GPIO_PIN_10;
	LL_GPIO_Init  (GPIOA,&GPIO_InitStruct);

	LL_APB2_GRP1_EnableClock  (LL_APB2_GRP1_PERIPH_USART1 ) ;


	LL_USART_InitTypeDef  USART_InitStruct;

	USART_InitStruct.BaudRate = 9600;
	USART_InitStruct.DataWidth = LL_USART_DATAWIDTH_8B;
	USART_InitStruct.HardwareFlowControl = LL_USART_HWCONTROL_NONE;
	USART_InitStruct.OverSampling = LL_USART_OVERSAMPLING_16;
	USART_InitStruct.Parity = LL_USART_PARITY_NONE;
	USART_InitStruct.StopBits = LL_USART_STOPBITS_1;
	USART_InitStruct.TransferDirection = LL_USART_DIRECTION_TX_RX;
	LL_USART_Init  (USART1, &USART_InitStruct);

	LL_USART_ConfigAsyncMode(USART1);

	LL_USART_Enable(USART1);

	printf(TERM_BBLUE "Compiled: " __TIME__ " " __DATE__ "\r\n" TERM_DEFAULT);

  while (1)
  {

	LL_GPIO_TogglePin  (GPIOG, LL_GPIO_PIN_13 | LL_GPIO_PIN_14);

	printf(TERM_YELLOW "Yellow  \r\n" TERM_DEFAULT);
	printf(TERM_DEFAULT "Normal  \r\n" TERM_DEFAULT);
	for(i=0;i<1000000;i++);

  }

}




/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
