//******************************************************************************
//* Driver for the SD memory card.                                             *
//* Written by   : Tamas Raikovich                                             *
//* Version      : 1.0                                                         *
//* Last modified: 2012.10.11.                                                 *
//******************************************************************************
#ifndef MEMORY_CARD_H_INCLUDED
#define MEMORY_CARD_H_INCLUDED

//******************************************************************************
//* Memory card types.                                                         *
//******************************************************************************
#define MEMCARD_TYPE_MMC        0x01    //MMC version 3.
#define MEMCARD_TYPE_SD1        0x02    //SD  version 1.
#define MEMCARD_TYPE_SD2        0x04    //SD  version 2.
#define MEMCARD_TYPE_BLOCK      0x08    //High capacity card (uses block adresses).

#define MEMCARD_TYPE_SDC        (MEMCARD_TYPE_SD1 | MEMCARD_TYPE_SD2)
#define MEMCARD_TYPE_SDHC       (MEMCARD_TYPE_SD2 | MEMCARD_TYPE_BLOCK)


//******************************************************************************
//* Status codes.                                                              *
//******************************************************************************
#define DISK_OK         0       //No error.
#define DISK_NOINIT     1       //Unable to initialize the card.
#define DISK_IOERR      2       //I/O error.
#define DISK_NOTRDY     3       //The card is not ready.
#define DISK_PARERR     4       //Invalid parameter.


//******************************************************************************
//* Function prototypes.                                                       *
//******************************************************************************
unsigned char MemCardInitialize();
unsigned char MemCardGetType();
unsigned char *MemCardGetSectorBuffer();
unsigned char MemCardReadPartialSector(unsigned long, unsigned char *, unsigned short, unsigned short);
unsigned char MemCardReadMultipleSectors(unsigned long, unsigned char *, unsigned char);
unsigned char MemCardWritePartialSector(unsigned long, unsigned char  *, unsigned short, unsigned short);
unsigned char MemCardWriteMultipleSectors(unsigned long, unsigned char *,unsigned char);


#endif  //MEMORY_CARD_H_INCLUDED
