//******************************************************************************
//* ENC424J600 register definitions.                                           *
//* Written by   : Tamas Raikovich (rtamas@mit.bme.hu)                         *
//* Version      : 1.0                                                         *
//* Last modified: 06/24/2010                                                  *
//******************************************************************************
#ifndef ENC424J600_REGISTERS_H_
#define ENC424J600_REGISTERS_H_

//*****************************************************************************
//* Constants.                                                                *
//*****************************************************************************
//Number of bits to left shift the register addresses.
#define REG_ADDR_SHIFT  2
//Register address mask.
#define REG_ADDR_MASK   (0x01ff << REG_ADDR_SHIFT)


//*****************************************************************************
//* Bit set and bit clear register offsets.                                   *
//*****************************************************************************
#define BITS_SET    (0x0100 << REG_ADDR_SHIFT)
#define BITS_CLR    (0x0180 << REG_ADDR_SHIFT)


//*****************************************************************************
//* ENC424J600 10/100 Ethernet controller register addresses.                 *
//*****************************************************************************
#define ETXST       (0x7E00 << REG_ADDR_SHIFT)
#define ETXSTL      (0x7E00 << REG_ADDR_SHIFT)
#define ETXSTH      (0x7E01 << REG_ADDR_SHIFT)
#define ETXLEN      (0x7E02 << REG_ADDR_SHIFT)
#define ETXLENL     (0x7E02 << REG_ADDR_SHIFT)
#define ETXLENH     (0x7E03 << REG_ADDR_SHIFT)
#define ERXST       (0x7E04 << REG_ADDR_SHIFT)
#define ERXSTL      (0x7E04 << REG_ADDR_SHIFT)
#define ERXSTH      (0x7E05 << REG_ADDR_SHIFT)
#define ERXTAIL     (0x7E06 << REG_ADDR_SHIFT)
#define ERXTAILL    (0x7E06 << REG_ADDR_SHIFT)
#define ERXTAILH    (0x7E07 << REG_ADDR_SHIFT)
#define ERXHEAD     (0x7E08 << REG_ADDR_SHIFT)
#define ERXHEADL    (0x7E08 << REG_ADDR_SHIFT)
#define ERXHEADH    (0x7E09 << REG_ADDR_SHIFT)
#define EDMAST      (0x7E0A << REG_ADDR_SHIFT)
#define EDMASTL     (0x7E0A << REG_ADDR_SHIFT)
#define EDMASTH     (0x7E0B << REG_ADDR_SHIFT)
#define EDMALEN     (0x7E0C << REG_ADDR_SHIFT)
#define EDMALENL    (0x7E0C << REG_ADDR_SHIFT)
#define EDMALENH    (0x7E0D << REG_ADDR_SHIFT)
#define EDMADST     (0x7E0E << REG_ADDR_SHIFT)
#define EDMADSTL    (0x7E0E << REG_ADDR_SHIFT)
#define EDMADSTH    (0x7E0F << REG_ADDR_SHIFT)
#define EDMACS      (0x7E10 << REG_ADDR_SHIFT)
#define EDMACSL     (0x7E10 << REG_ADDR_SHIFT)
#define EDMACSH     (0x7E11 << REG_ADDR_SHIFT)
#define ETXSTAT     (0x7E12 << REG_ADDR_SHIFT)
#define ETXSTATL    (0x7E12 << REG_ADDR_SHIFT)
#define ETXSTATH    (0x7E13 << REG_ADDR_SHIFT)
#define ETXWIRE     (0x7E14 << REG_ADDR_SHIFT)
#define ETXWIREL    (0x7E14 << REG_ADDR_SHIFT)
#define ETXWIREH    (0x7E15 << REG_ADDR_SHIFT)

#define EUDAST      (0x7E16 << REG_ADDR_SHIFT)
#define EUDASTL     (0x7E16 << REG_ADDR_SHIFT)
#define EUDASTH     (0x7E17 << REG_ADDR_SHIFT)
#define EUDAND      (0x7E18 << REG_ADDR_SHIFT)
#define EUDANDL     (0x7E18 << REG_ADDR_SHIFT)
#define EUDANDH     (0x7E19 << REG_ADDR_SHIFT)
#define ESTAT       (0x7E1A << REG_ADDR_SHIFT)
#define ESTATL      (0x7E1A << REG_ADDR_SHIFT)
#define ESTATH      (0x7E1B << REG_ADDR_SHIFT)
#define EIR         (0x7E1C << REG_ADDR_SHIFT)
#define EIRL        (0x7E1C << REG_ADDR_SHIFT)
#define EIRH        (0x7E1D << REG_ADDR_SHIFT)
#define ECON1       (0x7E1E << REG_ADDR_SHIFT)
#define ECON1L      (0x7E1E << REG_ADDR_SHIFT)
#define ECON1H      (0x7E1F << REG_ADDR_SHIFT)

#define EHT1        (0x7E20 << REG_ADDR_SHIFT)
#define EHT1L       (0x7E20 << REG_ADDR_SHIFT)
#define EHT1H       (0x7E21 << REG_ADDR_SHIFT)
#define EHT2        (0x7E22 << REG_ADDR_SHIFT)
#define EHT2L       (0x7E22 << REG_ADDR_SHIFT)
#define EHT2H       (0x7E23 << REG_ADDR_SHIFT)
#define EHT3        (0x7E24 << REG_ADDR_SHIFT)
#define EHT3L       (0x7E24 << REG_ADDR_SHIFT)
#define EHT3H       (0x7E25 << REG_ADDR_SHIFT)
#define EHT4        (0x7E26 << REG_ADDR_SHIFT)
#define EHT4L       (0x7E26 << REG_ADDR_SHIFT)
#define EHT4H       (0x7E27 << REG_ADDR_SHIFT)
#define EPMM1       (0x7E28 << REG_ADDR_SHIFT)
#define EPMM1L      (0x7E28 << REG_ADDR_SHIFT)
#define EPMM1H      (0x7E29 << REG_ADDR_SHIFT)
#define EPMM2       (0x7E2A << REG_ADDR_SHIFT)
#define EPMM2L      (0x7E2A << REG_ADDR_SHIFT)
#define EPMM2H      (0x7E2B << REG_ADDR_SHIFT)
#define EPMM3       (0x7E2C << REG_ADDR_SHIFT)
#define EPMM3L      (0x7E2C << REG_ADDR_SHIFT)
#define EPMM3H      (0x7E2D << REG_ADDR_SHIFT)
#define EPMM4       (0x7E2E << REG_ADDR_SHIFT)
#define EPMM4L      (0x7E2E << REG_ADDR_SHIFT)
#define EPMM4H      (0x7E2F << REG_ADDR_SHIFT)
#define EPMCS       (0x7E30 << REG_ADDR_SHIFT)
#define EPMCSL      (0x7E30 << REG_ADDR_SHIFT)
#define EPMCSH      (0x7E31 << REG_ADDR_SHIFT)
#define EPMO        (0x7E32 << REG_ADDR_SHIFT)
#define EPMOL       (0x7E32 << REG_ADDR_SHIFT)
#define EPMOH       (0x7E33 << REG_ADDR_SHIFT)
#define ERXFCON     (0x7E34 << REG_ADDR_SHIFT)
#define ERXFCONL    (0x7E34 << REG_ADDR_SHIFT)
#define ERXFCONH    (0x7E35 << REG_ADDR_SHIFT)

#define MACON1      (0x7E40 << REG_ADDR_SHIFT)
#define MACON1L     (0x7E40 << REG_ADDR_SHIFT)
#define MACON1H     (0x7E41 << REG_ADDR_SHIFT)
#define MACON2      (0x7E42 << REG_ADDR_SHIFT)
#define MACON2L     (0x7E42 << REG_ADDR_SHIFT)
#define MACON2H     (0x7E43 << REG_ADDR_SHIFT)
#define MABBIPG     (0x7E44 << REG_ADDR_SHIFT)
#define MABBIPGL    (0x7E44 << REG_ADDR_SHIFT)
#define MABBIPGH    (0x7E45 << REG_ADDR_SHIFT)
#define MAIPG       (0x7E46 << REG_ADDR_SHIFT)
#define MAIPGL      (0x7E46 << REG_ADDR_SHIFT)
#define MAIPGH      (0x7E47 << REG_ADDR_SHIFT)
#define MACLCON     (0x7E48 << REG_ADDR_SHIFT)
#define MACLCONL    (0x7E48 << REG_ADDR_SHIFT)
#define MACLCONH    (0x7E49 << REG_ADDR_SHIFT)
#define MAMXFL      (0x7E4A << REG_ADDR_SHIFT)
#define MAMXFLL     (0x7E4A << REG_ADDR_SHIFT)
#define MAMXFLH     (0x7E4B << REG_ADDR_SHIFT)

#define MICMD       (0x7E52 << REG_ADDR_SHIFT)
#define MICMDL      (0x7E52 << REG_ADDR_SHIFT)
#define MICMDH      (0x7E53 << REG_ADDR_SHIFT)
#define MIREGADR    (0x7E54 << REG_ADDR_SHIFT)
#define MIREGADRL   (0x7E54 << REG_ADDR_SHIFT)
#define MIREGADRH   (0x7E55 << REG_ADDR_SHIFT)

#define MAADR3      (0x7E60 << REG_ADDR_SHIFT)
#define MAADR3L     (0x7E60 << REG_ADDR_SHIFT)
#define MAADR3H     (0x7E61 << REG_ADDR_SHIFT)
#define MAADR2      (0x7E62 << REG_ADDR_SHIFT)
#define MAADR2L     (0x7E62 << REG_ADDR_SHIFT)
#define MAADR2H     (0x7E63 << REG_ADDR_SHIFT)
#define MAADR1      (0x7E64 << REG_ADDR_SHIFT)
#define MAADR1L     (0x7E64 << REG_ADDR_SHIFT)
#define MAADR1H     (0x7E65 << REG_ADDR_SHIFT)
#define MIWR        (0x7E66 << REG_ADDR_SHIFT)
#define MIWRL       (0x7E66 << REG_ADDR_SHIFT)
#define MIWRH       (0x7E67 << REG_ADDR_SHIFT)
#define MIRD        (0x7E68 << REG_ADDR_SHIFT)
#define MIRDL       (0x7E68 << REG_ADDR_SHIFT)
#define MIRDH       (0x7E69 << REG_ADDR_SHIFT)
#define MISTAT      (0x7E6A << REG_ADDR_SHIFT)
#define MISTATL     (0x7E6A << REG_ADDR_SHIFT)
#define MISTATH     (0x7E6B << REG_ADDR_SHIFT)
#define EPAUS       (0x7E6C << REG_ADDR_SHIFT)
#define EPAUSL      (0x7E6C << REG_ADDR_SHIFT)
#define EPAUSH      (0x7E6D << REG_ADDR_SHIFT)
#define ECON2       (0x7E6E << REG_ADDR_SHIFT)
#define ECON2L      (0x7E6E << REG_ADDR_SHIFT)
#define ECON2H      (0x7E6F << REG_ADDR_SHIFT)
#define ERXWM       (0x7E70 << REG_ADDR_SHIFT)
#define ERXWML      (0x7E70 << REG_ADDR_SHIFT)
#define ERXWMH      (0x7E71 << REG_ADDR_SHIFT)
#define EIE         (0x7E72 << REG_ADDR_SHIFT)
#define EIEL        (0x7E72 << REG_ADDR_SHIFT)
#define EIEH        (0x7E73 << REG_ADDR_SHIFT)
#define EIDLED      (0x7E74 << REG_ADDR_SHIFT)
#define EIDLEDL     (0x7E74 << REG_ADDR_SHIFT)
#define EIDLEDH     (0x7E75 << REG_ADDR_SHIFT)

#define EGPDATA     (0x7E80 << REG_ADDR_SHIFT)
#define EGPDATAL    (0x7E80 << REG_ADDR_SHIFT)
#define ERXDATA     (0x7E82 << REG_ADDR_SHIFT)
#define ERXDATAL    (0x7E82 << REG_ADDR_SHIFT)
#define EUDADATA    (0x7E84 << REG_ADDR_SHIFT)
#define EUDADATAL   (0x7E84 << REG_ADDR_SHIFT)
#define EGPRDPT     (0x7E86 << REG_ADDR_SHIFT)
#define EGPRDPTL    (0x7E86 << REG_ADDR_SHIFT)
#define EGPRDPTH    (0x7E87 << REG_ADDR_SHIFT)
#define EGPWRPT     (0x7E88 << REG_ADDR_SHIFT)
#define EGPWRPTL    (0x7E88 << REG_ADDR_SHIFT)
#define EGPWRPTH    (0x7E89 << REG_ADDR_SHIFT)
#define ERXRDPT     (0x7E8A << REG_ADDR_SHIFT)
#define ERXRDPTL    (0x7E8A << REG_ADDR_SHIFT)
#define ERXRDPTH    (0x7E8B << REG_ADDR_SHIFT)
#define ERXWRPT     (0x7E8C << REG_ADDR_SHIFT)
#define ERXWRPTL    (0x7E8C << REG_ADDR_SHIFT)
#define ERXWRPTH    (0x7E8D << REG_ADDR_SHIFT)
#define EUDARDPT    (0x7E8E << REG_ADDR_SHIFT)
#define EUDARDPTL   (0x7E8E << REG_ADDR_SHIFT)
#define EUDARDPTH   (0x7E8F << REG_ADDR_SHIFT)
#define EUDAWRPT    (0x7E90 << REG_ADDR_SHIFT)
#define EUDAWRPTL   (0x7E90 << REG_ADDR_SHIFT)
#define EUDAWRPTH   (0x7E91 << REG_ADDR_SHIFT)


//*****************************************************************************
//* Ethernet PHY register addresses.                                          *
//*****************************************************************************
#define PHCON1      0x00
#define PHSTAT1     0x01
#define PHANA       0x04
#define PHANLPA     0x05
#define PHANE       0x06
#define PHCON2      0x11
#define PHSTAT2     0x1B
#define PHSTAT3     0x1F


//*****************************************************************************
//* Bits in the ENC424J600 10/100 Ethernet controller registers.              *
//*****************************************************************************
//Bits in the ESTAT register.
#define ESTAT_INT           (1 << 15)
#define ESTAT_FCIDLE        (1 << 14)
#define ESTAT_RXBUSY        (1 << 13)
#define ESTAT_CLKRDY        (1 << 12)
#define ESTAT_RSTDONE       (1 << 11)
#define ESTAT_PHYDPX        (1 << 10)
#define ESTAT_PHYRDY        (1 << 9)
#define ESTAT_PHYLNK        (1 << 8)
#define ESTAT_PKTCNT7       (1 << 7)
#define ESTAT_PKTCNT6       (1 << 6)
#define ESTAT_PKTCNT5       (1 << 5)
#define ESTAT_PKTCNT4       (1 << 4)
#define ESTAT_PKTCNT3       (1 << 3)
#define ESTAT_PKTCNT2       (1 << 2)
#define ESTAT_PKTCNT1       (1 << 1)
#define ESTAT_PKTCNT0       (1 << 0)
//Bits in the ESTATH register.
#define ESTATH_INT          (1 << 7)
#define ESTATH_FCIDLE       (1 << 6)
#define ESTATH_RXBUSY       (1 << 5)
#define ESTATH_CLKRDY       (1 << 4)
#define ESTATH_RSTDONE      (1 << 3)
#define ESTATH_PHYDPX       (1 << 2)
#define ESTATH_PHYRDY       (1 << 1)
#define ESTATH_PHYLNK       (1 << 0)
//Bits in the ESTATL register.
#define ESTATL_PKTCNT7      (1 << 7)
#define ESTATL_PKTCNT6      (1 << 6)
#define ESTATL_PKTCNT5      (1 << 5)
#define ESTATL_PKTCNT4      (1 << 4)
#define ESTATL_PKTCNT3      (1 << 3)
#define ESTATL_PKTCNT2      (1 << 2)
#define ESTATL_PKTCNT1      (1 << 1)
#define ESTATL_PKTCNT0      (1 << 0)

//Bits in the EIR register.
#define EIR_CRYPTEN         (1 << 15)
#define EIR_MODEXIF         (1 << 14)
#define EIR_HASHIF          (1 << 13)
#define EIR_AESIF           (1 << 12)
#define EIR_LINKIF          (1 << 11)
#define EIR_PRDYIF          (1 << 10)
#define EIR_PKTIF           (1 << 6)
#define EIR_DMAIF           (1 << 5)
#define EIR_TXIF            (1 << 3)
#define EIR_TXABTIF         (1 << 2)
#define EIR_RXABTIF         (1 << 1)
#define EIR_PCFULIF         (1 << 0)
//Bits in the EIRH register.
#define EIRH_CRYPTEN        (1 << 7)
#define EIRH_MODEXIF        (1 << 6)
#define EIRH_HASHIF         (1 << 5)
#define EIRH_AESIF          (1 << 4)
#define EIRH_LINKIF         (1 << 3)
#define EIRH_PRDYIF         (1 << 2)
//Bits in the EIRL register.
#define EIRL_PKTIF          (1 << 6)
#define EIRL_DMAIF          (1 << 5)
#define EIRL_TXIF           (1 << 3)
#define EIRL_TXABTIF        (1 << 2)
#define EIRL_RXABTIF        (1 << 1)
#define EIRL_PCFULIF        (1 << 0)

//Bits in the ECON1 register.
#define ECON1_MODEXST       (1 << 15)
#define ECON1_HASHEN        (1 << 14)
#define ECON1_HASHOP        (1 << 13)
#define ECON1_HASHLST       (1 << 12)
#define ECON1_AESST         (1 << 11)
#define ECON1_AESOP1        (1 << 10)
#define ECON1_AESOP0        (1 << 9)
#define ECON1_PKTDEC        (1 << 8)
#define ECON1_FCOP1         (1 << 7)
#define ECON1_FCOP0         (1 << 6)
#define ECON1_DMAST         (1 << 5)
#define ECON1_DMACPY        (1 << 4)
#define ECON1_DMACSSD       (1 << 3)
#define ECON1_DMANOCS       (1 << 2)
#define ECON1_TXRTS         (1 << 1)
#define ECON1_RXEN          (1 << 0)
//Bits in the ECON1H register.
#define ECON1H_MODEXST      (1 << 7)
#define ECON1H_HASHEN       (1 << 6)
#define ECON1H_HASHOP       (1 << 5)
#define ECON1H_HASHLST      (1 << 4)
#define ECON1H_AESST        (1 << 3)
#define ECON1H_AESOP1       (1 << 2)
#define ECON1H_AESOP0       (1 << 1)
#define ECON1H_PKTDEC       (1 << 0)
//Bits in the ECON1L register.
#define ECON1L_FCOP1        (1 << 7)
#define ECON1L_FCOP0        (1 << 6)
#define ECON1L_DMAST        (1 << 5)
#define ECON1L_DMACPY       (1 << 4)
#define ECON1L_DMACSSD      (1 << 3)
#define ECON1L_DMANOCS      (1 << 2)
#define ECON1L_TXRTS        (1 << 1)
#define ECON1L_RXEN         (1 << 0)

//Bits in the ETXSTAT register.
#define ETXSTAT_LATECOL     (1 << 10)
#define ETXSTAT_MAXCOL      (1 << 9)
#define ETXSTAT_EXDEFER     (1 << 8)
#define ETXSTAT_DEFER       (1 << 7)
#define ETXSTAT_CRCBAD      (1 << 4)
#define ETXSTAT_COLCNT3     (1 << 3)
#define ETXSTAT_COLCNT2     (1 << 2)
#define ETXSTAT_COLCNT1     (1 << 1)
#define ETXSTAT_COLCNT0     (1 << 0)
//Bits in the ETXSTATH register.
#define ETXSTATH_LATECOL    (1 << 2)
#define ETXSTATH_MAXCOL     (1 << 1)
#define ETXSTATH_EXDEFER    (1 << 0)
//Bits in the ETXSTATL register.
#define ETXSTATL_DEFER      (1 << 7)
#define ETXSTATL_CRCBAD     (1 << 4)
#define ETXSTATL_COLCNT3    (1 << 3)
#define ETXSTATL_COLCNT2    (1 << 2)
#define ETXSTATL_COLCNT1    (1 << 1)
#define ETXSTATL_COLCNT0    (1 << 0)

//Bits in the ERXFCON register.
#define ERXFCON_HTEN        (1 << 15)
#define ERXFCON_MPEN        (1 << 14)
#define ERXFCON_NOTPM       (1 << 12)
#define ERXFCON_PMEN3       (1 << 11)
#define ERXFCON_PMEN2       (1 << 10)
#define ERXFCON_PMEN1       (1 << 9)
#define ERXFCON_PMEN0       (1 << 8)
#define ERXFCON_CRCEEN      (1 << 7)
#define ERXFCON_CRCEN       (1 << 6)
#define ERXFCON_RUNTEEN     (1 << 5)
#define ERXFCON_RUNTEN      (1 << 4)
#define ERXFCON_UCEN        (1 << 3)
#define ERXFCON_NOTMEEN     (1 << 2)
#define ERXFCON_MCEN        (1 << 1)
#define ERXFCON_BCEN        (1 << 0)
//Bits in the ERXFCONH register.
#define ERXFCONH_HTEN       (1 << 7)
#define ERXFCONH_MPEN       (1 << 6)
#define ERXFCONH_NOTPM      (1 << 4)
#define ERXFCONH_PMEN3      (1 << 3)
#define ERXFCONH_PMEN2      (1 << 2)
#define ERXFCONH_PMEN1      (1 << 1)
#define ERXFCONH_PMEN0      (1 << 0)
//Bits in the ERXFCONL register.
#define ERXFCONL_CRCEEN     (1 << 7)
#define ERXFCONL_CRCEN      (1 << 6)
#define ERXFCONL_RUNTEEN    (1 << 5)
#define ERXFCONL_RUNTEN     (1 << 4)
#define ERXFCONL_UCEN       (1 << 3)
#define ERXFCONL_NOTMEEN    (1 << 2)
#define ERXFCONL_MCEN       (1 << 1)
#define ERXFCONL_BCEN       (1 << 0)

//Bits in the MACON1 register.
#define MACON1_LOOPBK       (1 << 4)
#define	MACON1_RXPAUS       (1 << 2)
#define	MACON1_PASSALL      (1 << 1)
//Bits in the MACON1L register.
#define MACON1L_LOOPBK      (1 << 4)
#define	MACON1L_RXPAUS      (1 << 2)
#define	MACON1L_PASSALL     (1 << 1)

//Bits in the MACON2 register.
#define	MACON2_DEFER        (1 << 14)
#define	MACON2_BPEN         (1 << 13)
#define	MACON2_NOBKOFF      (1 << 12)
#define	MACON2_PADCFG2      (1 << 7)
#define	MACON2_PADCFG1      (1 << 6)
#define	MACON2_PADCFG0      (1 << 5)
#define	MACON2_TXCRCEN      (1 << 4)
#define	MACON2_PHDREN       (1 << 3)
#define	MACON2_HFRMEN       (1 << 2)
#define	MACON2_FULDPX       (1 << 0)
//Bits in the MACON2H register.
#define	MACON2H_DEFER       (1 << 6)
#define	MACON2H_BPEN        (1 << 5)
#define	MACON2H_NOBKOFF     (1 << 4)
//Bits in the MACON2L register.
#define	MACON2L_PADCFG2     (1 << 7)
#define	MACON2L_PADCFG1     (1 << 6)
#define	MACON2L_PADCFG0     (1 << 5)
#define	MACON2L_TXCRCEN     (1 << 4)
#define	MACON2L_PHDREN      (1 << 3)
#define	MACON2L_HFRMEN      (1 << 2)
#define	MACON2L_FULDPX      (1 << 0)

//Bits in the MABBIPG register.
#define MABBIPG_BBIPG6      (1 << 6)
#define MABBIPG_BBIPG5      (1 << 5)
#define MABBIPG_BBIPG4      (1 << 4)
#define MABBIPG_BBIPG3      (1 << 3)
#define MABBIPG_BBIPG2      (1 << 2)
#define MABBIPG_BBIPG1      (1 << 1)
#define MABBIPG_BBIPG0      (1 << 0)
//Bits in the MABBIPGL register.
#define MABBIPGL_BBIPG6     (1 << 6)
#define MABBIPGL_BBIPG5     (1 << 5)
#define MABBIPGL_BBIPG4     (1 << 4)
#define MABBIPGL_BBIPG3     (1 << 3)
#define MABBIPGL_BBIPG2     (1 << 2)
#define MABBIPGL_BBIPG1     (1 << 1)
#define MABBIPGL_BBIPG0     (1 << 0)

//Bits in the MAIPG register.
#define MAIPG_IPG6          (1 << 6)
#define MAIPG_IPG5          (1 << 5)
#define MAIPG_IPG4          (1 << 4)
#define MAIPG_IPG3          (1 << 3)
#define MAIPG_IPG2          (1 << 2)
#define MAIPG_IPG1          (1 << 1)
#define MAIPG_IPG0          (1 << 0)
//Bits in the MAIPGL register.
#define MAIPGL_IPG6         (1 << 6)
#define MAIPGL_IPG5         (1 << 5)
#define MAIPGL_IPG4         (1 << 4)
#define MAIPGL_IPG3         (1 << 3)
#define MAIPGL_IPG2         (1 << 2)
#define MAIPGL_IPG1         (1 << 1)
#define MAIPGL_IPG0         (1 << 0)

//Bits in the MACLCON register.
#define MACLCON_MAXRET3     (1 << 3)
#define MACLCON_MAXRET2     (1 << 2)
#define MACLCON_MAXRET1     (1 << 1)
#define MACLCON_MAXRET0     (1 << 0)
//Bits in the MACLCONL register.
#define MACLCONL_MAXRET3    (1 << 3)
#define MACLCONL_MAXRET2    (1 << 2)
#define MACLCONL_MAXRET1    (1 << 1)
#define MACLCONL_MAXRET0    (1 << 0)

//Bits in the MICMD register.
#define	MICMD_MIISCAN       (1 << 1)
#define	MICMD_MIIRD         (1 << 0)
//Bits in the MICMDL register.
#define	MICMDL_MIISCAN      (1 << 1)
#define	MICMDL_MIIRD        (1 << 0)

//Bits in the MIREGADR register.
#define MIREGADR_PHREG4     (1 << 4)
#define MIREGADR_PHREG3     (1 << 3)
#define MIREGADR_PHREG2     (1 << 2)
#define MIREGADR_PHREG1     (1 << 1)
#define MIREGADR_PHREG0     (1 << 0)
//Bits in the MIREGADRL register.
#define MIREGADRL_PHREG4    (1 << 4)
#define MIREGADRL_PHREG3    (1 << 3)
#define MIREGADRL_PHREG2    (1 << 2)
#define MIREGADRL_PHREG1    (1 << 1)
#define MIREGADRL_PHREG0    (1 << 0)

//Bits in the MISTAT register.
#define	MISTAT_NVALID       (1 << 2)
#define	MISTAT_SCAN         (1 << 1)
#define	MISTAT_BUSY         (1 << 0)
//Bits in the MISTATL register.
#define	MISTATL_NVALID      (1 << 2)
#define	MISTATL_SCAN        (1 << 1)
#define	MISTATL_BUSY        (1 << 0)

//Bits in the ECON2 register.
#define ECON2_ETHEN         (1 << 15)
#define ECON2_STRCH         (1 << 14)
#define ECON2_TXMAC         (1 << 13)
#define ECON2_SHA1MD5       (1 << 12)
#define ECON2_COCON3        (1 << 11)
#define ECON2_COCON2        (1 << 10)
#define ECON2_COCON1        (1 << 9)
#define ECON2_COCON0        (1 << 8)
#define ECON2_AUTOFC        (1 << 7)
#define ECON2_TXRST         (1 << 6)
#define ECON2_RXRST         (1 << 5)
#define ECON2_ETHRST        (1 << 4)
#define ECON2_MODLEN1       (1 << 3)
#define ECON2_MODLEN0       (1 << 2)
#define ECON2_AESLEN1       (1 << 1)
#define ECON2_AESLEN0       (1 << 0)
//Bits in the ECON2H register.
#define ECON2H_ETHEN        (1 << 7)
#define ECON2H_STRCH        (1 << 6)
#define ECON2H_TXMAC        (1 << 5)
#define ECON2H_SHA1MD5      (1 << 4)
#define ECON2H_COCON3       (1 << 3)
#define ECON2H_COCON2       (1 << 2)
#define ECON2H_COCON1       (1 << 1)
#define ECON2H_COCON0       (1 << 0)
//Bits in the ECON2L register.
#define ECON2L_AUTOFC       (1 << 7)
#define ECON2L_TXRST        (1 << 6)
#define ECON2L_RXRST        (1 << 5)
#define ECON2L_ETHRST       (1 << 4)
#define ECON2L_MODLEN1      (1 << 3)
#define ECON2L_MODLEN0      (1 << 2)
#define ECON2L_AESLEN1      (1 << 1)
#define ECON2L_AESLEN0      (1 << 0)

//Bits in the ERXWM register.
#define ERXWM_RXFWM7        (1 << 15)
#define ERXWM_RXFWM6        (1 << 14)
#define ERXWM_RXFWM5        (1 << 13)
#define ERXWM_RXFWM4        (1 << 12)
#define ERXWM_RXFWM3        (1 << 11)
#define ERXWM_RXFWM2        (1 << 10)
#define ERXWM_RXFWM1        (1 << 9)
#define ERXWM_RXFWM0        (1 << 8)
#define ERXWM_RXEWM7        (1 << 7)
#define ERXWM_RXEWM6        (1 << 6)
#define ERXWM_RXEWM5        (1 << 5)
#define ERXWM_RXEWM4        (1 << 4)
#define ERXWM_RXEWM3        (1 << 3)
#define ERXWM_RXEWM2        (1 << 2)
#define ERXWM_RXEWM1        (1 << 1)
#define ERXWM_RXEWM0        (1 << 0)
//Bits in the ERXWMH register.
#define ERXWMH_RXFWM7       (1 << 7)
#define ERXWMH_RXFWM6       (1 << 6)
#define ERXWMH_RXFWM5       (1 << 5)
#define ERXWMH_RXFWM4       (1 << 4)
#define ERXWMH_RXFWM3       (1 << 3)
#define ERXWMH_RXFWM2       (1 << 2)
#define ERXWMH_RXFWM1       (1 << 1)
#define ERXWMH_RXFWM0       (1 << 0)
//Bits in the ERXWML register.
#define ERXWML_RXEWM7       (1 << 7)
#define ERXWML_RXEWM6       (1 << 6)
#define ERXWML_RXEWM5       (1 << 5)
#define ERXWML_RXEWM4       (1 << 4)
#define ERXWML_RXEWM3       (1 << 3)
#define ERXWML_RXEWM2       (1 << 2)
#define ERXWML_RXEWM1       (1 << 1)
#define ERXWML_RXEWM0       (1 << 0)

//Bits in the EIE register.
#define EIE_INTIE           (1 << 15)
#define EIE_MODEXIE         (1 << 14)
#define EIE_HASHIE          (1 << 13)
#define EIE_AESIE           (1 << 12)
#define EIE_LINKIE          (1 << 11)
#define EIE_PRDYIE          (1 << 10)
#define EIE_PKTIE           (1 << 6)
#define EIE_DMAIE           (1 << 5)
#define EIE_TXIE            (1 << 3)
#define EIE_TXABTIE         (1 << 2)
#define EIE_RXABTIE         (1 << 1)
#define EIE_PCFULIE         (1 << 0)
//Bits in the EIEH register.
#define EIEH_INTIE          (1 << 7)
#define EIEH_MODEXIE        (1 << 6)
#define EIEH_HASHIE         (1 << 5)
#define EIEH_AESIE          (1 << 4)
#define EIEH_LINKIE         (1 << 3)
#define EIEH_PRDYIE         (1 << 2)
//Bits in the EIEL register.
#define EIEL_PKTIE          (1 << 6)
#define EIEL_DMAIE          (1 << 5)
#define EIEL_TXIE           (1 << 3)
#define EIEL_TXABTIE        (1 << 2)
#define EIEL_RXABTIE        (1 << 1)
#define EIEL_PCFULIE        (1 << 0)

//Bits in the EIDLED register.
#define EIDLED_LACFG3       (1 << 15)
#define EIDLED_LACFG2       (1 << 14)
#define EIDLED_LACFG1       (1 << 13)
#define EIDLED_LACFG0       (1 << 12)
#define EIDLED_LBCFG3       (1 << 11)
#define EIDLED_LBCFG2       (1 << 10)
#define EIDLED_LBCFG1       (1 << 9)
#define EIDLED_LBCFG0       (1 << 8)
#define EIDLED_DEVID2       (1 << 7)
#define EIDLED_DEVID1       (1 << 6)
#define EIDLED_DEVID0       (1 << 5)
#define EIDLED_REVID4       (1 << 4)
#define EIDLED_REVID3       (1 << 3)
#define EIDLED_REVID2       (1 << 2)
#define EIDLED_REVID1       (1 << 1)
#define EIDLED_REVID0       (1 << 0)
//Bits in the EIDLEDH register.
#define EIDLEDH_LACFG3      (1 << 7)
#define EIDLEDH_LACFG2      (1 << 6)
#define EIDLEDH_LACFG1      (1 << 5)
#define EIDLEDH_LACFG0      (1 << 4)
#define EIDLEDH_LBCFG3      (1 << 3)
#define EIDLEDH_LBCFG2      (1 << 2)
#define EIDLEDH_LBCFG1      (1 << 1)
#define EIDLEDH_LBCFG0      (1 << 0)
//Bits in the EIDLEDL register.
#define EIDLEDL_DEVID2      (1 << 7)
#define EIDLEDL_DEVID1      (1 << 6)
#define EIDLEDL_DEVID0      (1 << 5)
#define EIDLEDL_REVID4      (1 << 4)
#define EIDLEDL_REVID3      (1 << 3)
#define EIDLEDL_REVID2      (1 << 2)
#define EIDLEDL_REVID1      (1 << 1)
#define EIDLEDL_REVID0      (1 << 0)


//*****************************************************************************
//* Bits in the Ethernet PHY registers.                                       *
//*****************************************************************************
//Bits in the PHCON1 register.
#define PHCON1_PRST         (1 << 15)
#define PHCON1_PLOOPBK      (1 << 14)
#define PHCON1_SPD100       (1 << 13)
#define PHCON1_ANEN         (1 << 12)
#define PHCON1_PSLEEP       (1 << 11)
#define PHCON1_RENEG        (1 << 9)
#define PHCON1_PFULDPX      (1 << 8)

//Bits in the PHSTAT1 register.
#define PHSTAT1_FULL100     (1 << 14)
#define PHSTAT1_HALF100     (1 << 13)
#define PHSTAT1_FULL10      (1 << 12)
#define PHSTAT1_HALF10      (1 << 11)
#define PHSTAT1_ANDONE      (1 << 5)
#define PHSTAT1_LRFAULT     (1 << 4)
#define PHSTAT1_ANABLE      (1 << 3)
#define PHSTAT1_LLSTAT      (1 << 2)
#define PHSTAT1_EXTREGS     (1 << 0)

//Bits in the PHANA register.
#define PHANA_ADNP          (1 << 15)
#define PHANA_ADFAULT       (1 << 13)
#define PHANA_ADPAUS1       (1 << 11)
#define PHANA_ADPAUS0       (1 << 10)
#define PHANA_AD100FD       (1 << 8)
#define PHANA_AD100         (1 << 7)
#define PHANA_AD10FD        (1 << 6)
#define PHANA_AD10          (1 << 5)
#define PHANA_ADIEEE4       (1 << 4)
#define PHANA_ADIEEE3       (1 << 3)
#define PHANA_ADIEEE2       (1 << 2)
#define PHANA_ADIEEE1       (1 << 1)
#define PHANA_ADIEEE0       (1 << 0)

//Bits in the PHANLPA register.
#define PHANLPA_LPNP        (1 << 15)
#define PHANLPA_LPACK       (1 << 14)
#define PHANLPA_LPFAULT     (1 << 13)
#define PHANLPA_LPPAUS1     (1 << 11)
#define PHANLPA_LPPAUS0     (1 << 10)
#define PHANLPA_LP100T4     (1 << 9)
#define PHANLPA_LP100FD     (1 << 8)
#define PHANLPA_LP100       (1 << 7)
#define PHANLPA_LP10FD      (1 << 6)
#define PHANLPA_LP10        (1 << 5)
#define PHANLPA_LPIEEE4     (1 << 4)
#define PHANLPA_LPIEEE3     (1 << 3)
#define PHANLPA_LPIEEE2     (1 << 2)
#define PHANLPA_LPIEEE1     (1 << 1)
#define PHANLPA_LPIEEE0     (1 << 0)

//Bits in the PHANE register.
#define PHANE_PDFLT         (1 << 4)
#define PHANE_LPARCD        (1 << 1)
#define PHANA_LPANABL       (1 << 0)

//Bits in the PHCON2 register.
#define PHCON2_EDPWRDN      (1 << 13)
#define PHCON2_EDTHRES      (1 << 11)
#define PHCON2_FRCLNK       (1 << 2)
#define PHCON2_EDSTAT       (1 << 1)

//Bits in the PHSTAT2 register.
#define PHSTAT2_PLRITY      (1 << 4)

//Bits in the PHSTAT3 register.
#define PHSTAT3_SPDDPX2     (1 << 4)
#define PHSTAT3_SPDDPX1     (1 << 3)
#define PHSTAT3_SPDDPX0     (1 << 2)


#endif /*ENC424J600_REGISTERS_H_*/
