//******************************************************************************
//* Driver for the LOGSYS SPI peripheral.                                      *
//* Written by   : Tamas Raikovich                                             *
//* Version      : 1.0                                                         *
//* Last modified: 2012.10.11.                                                 *
//******************************************************************************
#ifndef SPI_H_
#define SPI_H_

//******************************************************************************
//* SPI device select values.                                                  *
//******************************************************************************
#define SPI_DEVICE_FLASH        0
#define SPI_DEVICE_LCD          1
#define SPI_DEVICE_SDCARD       2


//******************************************************************************
//* CRC type.                                                                  *
//******************************************************************************
#define SPI_CRC_TYPE_CRC7       0
#define SPI_CRC_TYPE_CRC16      1


//******************************************************************************
//* CRC source.                                                                *
//******************************************************************************
#define SPI_CRC_DIN_MOSI        0
#define SPI_CRC_DIN_MISO        1


//******************************************************************************
//* Function prototypes.                                                       *
//******************************************************************************
void SPISelect(unsigned long device, unsigned long clkFreq);
void SPIDeselect();
unsigned long SPIReadWriteByte(unsigned long data);
void SPIWriteBytes(unsigned char *src, unsigned long size);
void SPIReadBytes(unsigned char *dst, unsigned long size, unsigned char valueToSend);
void SPIInitCRC(unsigned long type, unsigned long src);
void SPISendCRC(unsigned long type);
unsigned long SPICheckCRC16();


#endif /* SPI_H_ */
