//******************************************************************************
//* Header file for the 'enc424j600.c'.                                        *
//* Written by   : Tamas Raikovich (rtamas@mit.bme.hu)                         *
//* Version      : 1.0                                                         *
//* Last modified: 06/24/2010                                                  *
//******************************************************************************
#ifndef ENC424J600_H_
#define ENC424J600_H_

//*****************************************************************************
//* Status values.                                                            *
//*****************************************************************************
#define ETH_STATUS_SUCCESS		0
#define ETH_STATUS_ERROR		1


//*****************************************************************************
//* Function prototypes.                                                      *
//*****************************************************************************
unsigned long EncInitialize(unsigned long mem_baseaddr);
unsigned long EncSetRxBufferSize(unsigned long mem_baseaddr, unsigned long size, unsigned long *nextRxPacketPtr);
unsigned long EncReadMacAddress(unsigned long mem_baseaddr, unsigned char *macaddr);
unsigned long EncInitializeMac(unsigned long mem_baseaddr, unsigned char *macaddr, unsigned long maxframelen);
unsigned long EncReceivePacket(unsigned long mem_baseaddr, void *dst, unsigned short *len, unsigned long *nextRxPacketPtr);
unsigned long EncWaitForTxComplete(unsigned long mem_baseaddr);
unsigned long EncTransmitPacket(unsigned long mem_baseaddr, unsigned long txstartaddr, unsigned short len);


#endif /*ENC424J600_H_*/
