//-----------------------------------------------------------------------------
// system_sdram_wrapper.v
//-----------------------------------------------------------------------------

module system_sdram_wrapper
  (
    clk,
    clk2x,
    rst,
    mem_addr,
    mem_wen,
    mem_lbn,
    mem_ubn,
    sram_csn,
    sram_oen,
    sdram_clk,
    sdram_cke,
    sdram_csn,
    init_done,
    xcl0_access_ctrl,
    xcl0_access_data,
    xcl0_access_wr,
    xcl0_access_full,
    xcl0_rddata_ctrl,
    xcl0_rddata_data,
    xcl0_rddata_rd,
    xcl0_rddata_exists,
    xcl1_access_ctrl,
    xcl1_access_data,
    xcl1_access_wr,
    xcl1_access_full,
    xcl1_rddata_ctrl,
    xcl1_rddata_data,
    xcl1_rddata_rd,
    xcl1_rddata_exists,
    mem_data_I,
    mem_data_O,
    mem_data_T
  );
  input clk;
  input clk2x;
  input rst;
  output [17:0] mem_addr;
  output mem_wen;
  output mem_lbn;
  output mem_ubn;
  output sram_csn;
  output sram_oen;
  output sdram_clk;
  output sdram_cke;
  output sdram_csn;
  output init_done;
  input xcl0_access_ctrl;
  input [0:31] xcl0_access_data;
  input xcl0_access_wr;
  output xcl0_access_full;
  output xcl0_rddata_ctrl;
  output [0:31] xcl0_rddata_data;
  input xcl0_rddata_rd;
  output xcl0_rddata_exists;
  input xcl1_access_ctrl;
  input [0:31] xcl1_access_data;
  input xcl1_access_wr;
  output xcl1_access_full;
  output xcl1_rddata_ctrl;
  output [0:31] xcl1_rddata_data;
  input xcl1_rddata_rd;
  output xcl1_rddata_exists;
  input [15:0] mem_data_I;
  output [15:0] mem_data_O;
  output [15:0] mem_data_T;

  logsys_xcl_sdram_ctrl
    #(
      .C_SYSCLK_PERIOD_PS ( 16667 ),
      .C_MEM_BASEADDR ( 32'hC0000000 ),
      .C_MEM_HIGHADDR ( 32'hC1FFFFFF ),
      .C_XCL0_LINESIZE ( 8 ),
      .C_XCL1_LINESIZE ( 8 ),
      .C_T_SDRAM_RP_NS ( 20 ),
      .C_T_SDRAM_RFC_NS ( 66 ),
      .C_T_SDRAM_RMD_CLK ( 2 ),
      .C_T_SDRAM_RCD_NS ( 20 ),
      .C_T_SDRAM_RC_NS ( 66 ),
      .C_T_SDRAM_RAS_MIN_NS ( 42 ),
      .C_T_SDRAM_RAS_MAX_NS ( 100000 ),
      .C_T_SDRAM_REFRESH_MS ( 64 ),
      .C_SDRAM_REFRESH_BURST ( 8 ),
      .C_SDRAM_CAS_LATENCY ( 2 )
    )
    SDRAM (
      .clk ( clk ),
      .clk2x ( clk2x ),
      .rst ( rst ),
      .mem_addr ( mem_addr ),
      .mem_wen ( mem_wen ),
      .mem_lbn ( mem_lbn ),
      .mem_ubn ( mem_ubn ),
      .sram_csn ( sram_csn ),
      .sram_oen ( sram_oen ),
      .sdram_clk ( sdram_clk ),
      .sdram_cke ( sdram_cke ),
      .sdram_csn ( sdram_csn ),
      .init_done ( init_done ),
      .xcl0_access_ctrl ( xcl0_access_ctrl ),
      .xcl0_access_data ( xcl0_access_data ),
      .xcl0_access_wr ( xcl0_access_wr ),
      .xcl0_access_full ( xcl0_access_full ),
      .xcl0_rddata_ctrl ( xcl0_rddata_ctrl ),
      .xcl0_rddata_data ( xcl0_rddata_data ),
      .xcl0_rddata_rd ( xcl0_rddata_rd ),
      .xcl0_rddata_exists ( xcl0_rddata_exists ),
      .xcl1_access_ctrl ( xcl1_access_ctrl ),
      .xcl1_access_data ( xcl1_access_data ),
      .xcl1_access_wr ( xcl1_access_wr ),
      .xcl1_access_full ( xcl1_access_full ),
      .xcl1_rddata_ctrl ( xcl1_rddata_ctrl ),
      .xcl1_rddata_data ( xcl1_rddata_data ),
      .xcl1_rddata_rd ( xcl1_rddata_rd ),
      .xcl1_rddata_exists ( xcl1_rddata_exists ),
      .mem_data_I ( mem_data_I ),
      .mem_data_O ( mem_data_O ),
      .mem_data_T ( mem_data_T )
    );

endmodule

