-------------------------------------------------------------------------------
-- system_stub.vhd
-------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

entity system_stub is
  port (
    dev_mosi : in std_logic;
    dev_miso : out std_logic;
    osc_clk : in std_logic;
    man_rstn : in std_logic;
    eth_en : out std_logic;
    eth_al : out std_logic;
    eth_rnw_ad8 : out std_logic;
    eth_ad : inout std_logic_vector(7 downto 0);
    eth_irq : in std_logic;
    spi_flash_csn : out std_logic;
    spi_lcd_csn : out std_logic;
    spi_sdcard_csn : out std_logic;
    spi_clk : out std_logic;
    spi_mosi : out std_logic;
    spi_miso : inout std_logic;
    SDRAM_mem_addr_pin : out std_logic_vector(17 downto 0);
    SDRAM_mem_data_pin : inout std_logic_vector(15 downto 0);
    SDRAM_mem_wen_pin : out std_logic;
    SDRAM_mem_lbn_pin : out std_logic;
    SDRAM_mem_ubn_pin : out std_logic;
    SDRAM_sram_csn_pin : out std_logic;
    SDRAM_sram_oen_pin : out std_logic;
    SDRAM_sdram_clk_pin : out std_logic;
    SDRAM_sdram_cke_pin : out std_logic;
    SDRAM_sdram_csn_pin : out std_logic;
    btn_in : in std_logic_vector(2 downto 0);
    cpld_jtagen : out std_logic;
    cpld_rstn : out std_logic;
    cpld_clk : out std_logic;
    cpld_load : out std_logic;
    cpld_mosi : out std_logic;
    cpld_miso : in std_logic;
    gpio_io : inout std_logic_vector(12 downto 0)
  );
end system_stub;

architecture STRUCTURE of system_stub is

  component system is
    port (
      dev_mosi : in std_logic;
      dev_miso : out std_logic;
      osc_clk : in std_logic;
      man_rstn : in std_logic;
      eth_en : out std_logic;
      eth_al : out std_logic;
      eth_rnw_ad8 : out std_logic;
      eth_ad : inout std_logic_vector(7 downto 0);
      eth_irq : in std_logic;
      spi_flash_csn : out std_logic;
      spi_lcd_csn : out std_logic;
      spi_sdcard_csn : out std_logic;
      spi_clk : out std_logic;
      spi_mosi : out std_logic;
      spi_miso : inout std_logic;
      SDRAM_mem_addr_pin : out std_logic_vector(17 downto 0);
      SDRAM_mem_data_pin : inout std_logic_vector(15 downto 0);
      SDRAM_mem_wen_pin : out std_logic;
      SDRAM_mem_lbn_pin : out std_logic;
      SDRAM_mem_ubn_pin : out std_logic;
      SDRAM_sram_csn_pin : out std_logic;
      SDRAM_sram_oen_pin : out std_logic;
      SDRAM_sdram_clk_pin : out std_logic;
      SDRAM_sdram_cke_pin : out std_logic;
      SDRAM_sdram_csn_pin : out std_logic;
      btn_in : in std_logic_vector(2 downto 0);
      cpld_jtagen : out std_logic;
      cpld_rstn : out std_logic;
      cpld_clk : out std_logic;
      cpld_load : out std_logic;
      cpld_mosi : out std_logic;
      cpld_miso : in std_logic;
      gpio_io : inout std_logic_vector(12 downto 0)
    );
  end component;

  attribute BOX_TYPE : STRING;
  attribute BOX_TYPE of system : component is "user_black_box";

begin

  system_i : system
    port map (
      dev_mosi => dev_mosi,
      dev_miso => dev_miso,
      osc_clk => osc_clk,
      man_rstn => man_rstn,
      eth_en => eth_en,
      eth_al => eth_al,
      eth_rnw_ad8 => eth_rnw_ad8,
      eth_ad => eth_ad,
      eth_irq => eth_irq,
      spi_flash_csn => spi_flash_csn,
      spi_lcd_csn => spi_lcd_csn,
      spi_sdcard_csn => spi_sdcard_csn,
      spi_clk => spi_clk,
      spi_mosi => spi_mosi,
      spi_miso => spi_miso,
      SDRAM_mem_addr_pin => SDRAM_mem_addr_pin,
      SDRAM_mem_data_pin => SDRAM_mem_data_pin,
      SDRAM_mem_wen_pin => SDRAM_mem_wen_pin,
      SDRAM_mem_lbn_pin => SDRAM_mem_lbn_pin,
      SDRAM_mem_ubn_pin => SDRAM_mem_ubn_pin,
      SDRAM_sram_csn_pin => SDRAM_sram_csn_pin,
      SDRAM_sram_oen_pin => SDRAM_sram_oen_pin,
      SDRAM_sdram_clk_pin => SDRAM_sdram_clk_pin,
      SDRAM_sdram_cke_pin => SDRAM_sdram_cke_pin,
      SDRAM_sdram_csn_pin => SDRAM_sdram_csn_pin,
      btn_in => btn_in,
      cpld_jtagen => cpld_jtagen,
      cpld_rstn => cpld_rstn,
      cpld_clk => cpld_clk,
      cpld_load => cpld_load,
      cpld_mosi => cpld_mosi,
      cpld_miso => cpld_miso,
      gpio_io => gpio_io
    );

end architecture STRUCTURE;

