function [y_est, x_est] = KalmanFilter(A,B,C,D,L,M,u,y_v)

u = u(:);
size_y_v = size(y_v);
if (size_y_v(1) ~= length(u))
    error ('Plant output length does not match input length');
end
num_of_outputs = size_y_v(2);

size_A = size(A);
if (size_A(1)~=size_A(2)) %A is not square
    error('A is not a square matrix');
else
    ss_dim = size_A(1); %dimension of the state space
end
size_MC = size(M*C);
if (size_MC(1)~=size_MC(2)) %MC is not a square matrix
    error('Size mismatch regarding M and C matrices.');
else
    eye_size = size_MC(1);
end

x_hat_minus = zeros (ss_dim,length(u)+1); %x_hat_minus[n] = x_hat[n|n-1]; x_hat_minus[n+1] = x_hat[n+1|n]
x_hat_null = zeros (ss_dim,length(u)); %x_hat_null[n] = x_hat[n|n];
y_hat_null = zeros(num_of_outputs,length(u)); %y_hat_null[n] = y_hat[n|n];

%Initializing state variables:
x_hat_minus(:,1) = zeros(ss_dim,1);

%Performing Kalman filtering:
for n = 1:length(u)
    %predicting next state:
    x_hat_minus(:,n+1) = A*x_hat_minus(:,n) + B*u(n) + L*(y_v(n) - C*x_hat_minus(:,n) - D*u(n));
    %updating estimators:
    y_hat_null(:,n) = C*(eye(eye_size) - M*C)*x_hat_minus(:,n) + (eye(1) - C*M)*D*u(n) + C*M*y_v(n,:).';
    x_hat_null(:,n) = (eye(eye_size) - M*C)*x_hat_minus(:,n) - M*D*u(n) + M*y_v(n,:).';
end

y_est = y_hat_null;
x_est = x_hat_null;

end