clc;
clear all;

M = 0.5; %[kg]
m = 0.2; %[kg]
b = 0.1; %[N/(m*sec)]
l = 0.3; %[m]
I = 0.006; %[kg*m^2]
g = 9.81; %[m/s^2]

den = I*(M+m)+M*m*l^2;

A = [0      1       0       0;    
    0  -(I+m*l^2)*b/den  (m^2*g*l^2)/den 0;
    0       0       0       1;
    0 -(m*l*b)/den  m*g*l*(M+m)/den 0];

B = [0;
    (I+m*l^2)/den;
    0;
    m*l/den];
    
C = [0 0 1 0;
     0 0 1 0];
D = [0; 0];

states = {'x' 'x_dot' 'phi' 'phi_dot'};
inputs = {'u'};
outputs = {'x_uot'; 'phi_out'};

nominal_plant_ct = ss(A,B,C,D,'statename',states,'inputname',inputs,'outputname',outputs);

%LQR state-ffedback control design
Q = 1e-3*eye(4); %x.'*Q*x
R = 1; %u.'*R*u;
N = zeros(4,1); %x.'*N*u
[K,S,e] = lqr(A,B,Q,R,N);
A_lq = A-B*K;
nominal_plant_ct_lq = ss(A_lq,B,C,D,'statename',states,'inputname',inputs,'outputname',outputs);

%Discretizing
fs = 100; %[Hz]
Ts = 1/fs;
nominal_plant_dt = c2d(nominal_plant_ct_lq,Ts,'tustin');

%Kalman Filter Design for DT plant
Qn = 3e-3; %E{ww.'}
Rn = 2e-2*eye(2); %E{vv.'}
Nn = [0 0]; %E{wv.'}

[kest,L,P,M,Z] = kalman(nominal_plant_dt,Qn,Rn,Nn);

first_sensor_offset = 1e-2;
first_sensor_drift = 5e-5;
f_u = 9.7; %[hz]
u_len = 1000;
time = (0:u_len-1).'*Ts;
u = repmat([zeros(round(u_len/10),1); ones(round(u_len/10),1)],5,1) - 0.5;
x_0 = [0;0;0;0];
y = lsim(nominal_plant_dt,u,time,x_0);
y_v = zeros(size(y));
y_v(:,1) = y(:,1) + linspace(first_sensor_drift,u_len*first_sensor_drift,u_len).';
y_v(:,2) = y(:,2) + Rn(1,1)*randn(u_len,1);
[y_est,x_est] = KalmanFilter(nominal_plant_dt.a,nominal_plant_dt.b,nominal_plant_dt.c,nominal_plant_dt.d,L,M,u,y_v);
y_est = y_est.'; %[Num of samples x Num of outputs]
figure(100);
subplot(3,1,1);
plot(time,y(:,1),time,y_v(:,1),time,y_est(:,1));
legend({'Valdi kimenet';'Zajos (mrt kimenet)';'Becslt kimenet'});
xlabel ('Ido [s]'); ylabel('Amplitd [v]');
subplot(3,1,2);
plot(time,y(:,2),time,y_v(:,2),time,y_est(:,2));
legend({'Valdi kimenet';'Zajos (mrt kimenet)';'Becslt kimenet'});
xlabel ('Ido [s]'); ylabel('Amplitd [v]');
subplot(3,1,3);
plot(time,y_est(:,2) - y(:,2));
legend({'Becslt s valdi kimenet klnbsge'});
xlabel ('Ido [s]'); ylabel('Amplitd [v]');
