clc;
clear all;
example = 1;
if (example == 1)
    fs = 48000; %Hz
    Ts = 1/fs;
    [A,B,C,D] = butter(3,0.15);
    d_butter_3 = ss(A,B,C,D,Ts);
    Qn = 0.08; %E{ww.'}
    Rn = 0.05; %E{vv.'}
    Nn = 0; %E{wv.'}

    %Kalman filter design:
    [ktest,L,P,M,Z] = kalman(d_butter_3,Qn,Rn,Nn);

    %Simulating system output:
    time = (1:fs).'/fs;
    f1 = 100; a1 = 1;
    f2 = 20000; a2 = 1;
    u = a1*cos(2*pi*f1*time) + a2*cos(2*pi*f2*time);
    y = lsim(d_butter_3,u);
    y_v = y + Rn*randn(length(y),1);

    %Kalman filtering
    [y_est,x_est] = KalmanFilter(A,B,C,D,L,M,u,y_v);
    show_simulated = 1;
    if (show_simulated)
        plot(time,y_v,time,y_est,time,y); legend({'Mrt kimenet','Becslt kimenet','Valdi kimenet'}); xlabel('Ido [s]'); ylabel('Amplitd [V]');shg;
    else
        plot(time,y_v,time,y_est); legend({'Mrt kimenet','Becslt kimenet'}); xlabel('Ido [s]'); ylabel('Amplitd [V]');shg;
    end

elseif (example == 2)
    fs = 48000; %Hz
    Ts = 1/fs;
    [A,B,C,D] = butter(5,0.1);
    d_butter_5 = ss(A,B,C,D,Ts);
    Qn = 0.08; %E{ww.'}
    Rn = 0.06; %E{vv.'}
    Nn = 0; %E{wv.'}

    %Kalman filter design:
    [ktest,L,P,M,Z] = kalman(d_butter_5,Qn,Rn,Nn);

    %Simulating system output:
    time = (1:fs).'/fs;
    f1 = 100; a1 = 1;
    f2 = 20000; a2 = 1;
    u = repmat([zeros(fs/10,1);ones(fs/10,1)],5,1);
    y = lsim(d_butter_5,u);
    y_v = y + 2*Rn*rand(length(y),1) - Rn*ones(length(y),1);

    %Kalman filtering
    [y_est,x_est] = KalmanFilter(A,B,C,D,L,M,u,y_v);
    show_simulated = 1;
    if (show_simulated)
        plot(time,y_v,time,y_est,time,y); legend({'Mrt kimenet','Becslt kimenet','Valdi kimenet'}); xlabel('Ido [s]'); ylabel('Amplitd [V]');shg;
    else
        plot(time,y_v,time,y_est); legend({'Mrt kimenet','Becslt kimenet'}); xlabel('Ido [s]'); ylabel('Amplitd [V]');shg;
    end
end

