%CSALO Csalka brk szinusz mintavtelezsekor

if ~exist('lan'), lan=2; end
n=9; n1=n-1;
n2=n+1;
N=n*n1*n2;t=[0:N-1]';
f=t/N;
np=2*n;
Tp=N/np; 
if rem(Tp,1)>0, error('Tp is not integer'), end

x=cos(2*pi/Tp*t);
clf, hold off, plot(t,x,'r')
ax=[0,N,-1.1,1.1]; axis(ax)
if lan==1
  title(sprintf('Sine wave, %.0f periods',np))
else
  title(sprintf('Szinusz, %.0f peridus',np))
end
figure(gcf), zoom on
drawnow, pause

d=divisors(N);
r=[];
for r=[1,2,4,8,16,24,36,40,45]
  while ~any(r==[d(:);1])
    disp('Possible decimation factors:')
    divisors(N)
    fprintf('Each period contains %.0f points\n',Tp)
    if isempty(r), r=10; end
    r=yesinput('Decimation factor',r,[1,max(d)]);
  end
  xs=x(1:r:length(x)); ts=t(1:r:length(t));
  clf
  %full axes: 0.1300    0.1100    0.7750    0.8150
  h1=axes('Position',[0.1300,0.41,0.775,0.5150]);
  lineplot(ts,xs)
  ax=[0,N,-1.1,1.1]; axis(ax)
  if lan==1
    title(sprintf('Sampled sequence, fs=%.3g*f1',Tp/r))
  else
    title(sprintf('Mintavtelezett sorozat, fs=%.3g*f1',Tp/r))
  end
  zoom on
  xsl=zeros(size(x)); xsl(1:r:length(xsl))=xs;
  XS=fft(xsl);
  pause
  h2=axes('Position',[0.1300,0.11,0.775,0.2150]);
  lineplot(f,abs(XS)), peak=max(abs(XS));
  %
  hold on, plot([1/r/2,1/r/2],[0,1.2*peak],':w'), hold off
  text(1/r/2,1.23*peak,'fsr/2','vertical','bottom','horizontal','center');
  hold on, plot([1/r,1/r],[0,1.2*peak],':b'), hold off
  text(1/r,1.23*peak,'fsr','vertical','bottom','horizontal','center');
  %
  hold on, plot([1/Tp,1/Tp],[0,1.01*peak],'-r'), hold off
  hold on, plot([1-1/Tp,1-1/Tp],[0,1.01*peak],'-r'), hold off
  fmax=min(1,max(9/Tp,9/r/2));
  ax=[0,fmax,0,1.6*peak]; axis(ax)
  if lan==1
    title(sprintf('Decimation factor: %.0f',r))
  else
    title(sprintf('Deciml tnyez: %.0f',r))
  end
  pause
  axes(h1), hold on
  h=plot(t,x,'.r','markersize',1);
  set(h,'MarkerSize',3,'marker','d')
  %for i=1:length(x)
  %  plot([t(i),t(i)],[x(i),x(i)],'-r')
  %end
  figure(gcf), hold off
  pause
end
