%DIFFEQ  Differenciaegyenletek illusztrcija

%Utols javts: 2002. nov. 9., KI

printfigs=1;
if ~exist('printfigs'), printfigs=0; end
if ~exist('fidmodel.m')
  %error('Fdident toolbox is not properly installed')
end
if strncmp(version,'5.2',3)
  error('A demonstrci csak legalbb 5.3 verzi alatt fut')
end
if exist('addq'), addq, end
if exist('qfigset')
  close all
  qfigset
  figure(1), qfigset
  figure(2), qfigset
  figure(3), qfigset
  figure(4), qfigset
end
%
if ~exist('typ'), typ='m'; end
disp('A rendszer tpusa:')
disp('mozg tlagols, differencia, exponencilis tlagols, fir, m/d/e/f')
typ=yesinput('Rendszer',typ,'m|d|e|f');
if strcmp(typ,'m')
  if ~exist('N'), N=5; end
  N=yesinput('Pontok szma, N',N,[2,inf]);
  if ~exist('del'), del='r'; end
  if rem(N,2)==1
    del=yesinput('Real-time (x(n+1)=...) or filtering, r/f',del,'r|f');
  else
    del='r';
    disp('Real-time moving averaging')
  end
  if ~exist('form'), form='d'; end
  form=yesinput('Form, direct or summed, d/s',form,'d|s');
  if strcmp(form,'d')
    if strcmp(del,'r')
      m=fidmodel('z^-1',[0,1/N*ones(1,N)],[1],0,1); %Direct form
    elseif strcmp(del,'f')
      m=fidmodel('z^-1',[0,1/N*ones(1,N)],[zeros(1,(N+1)/2),1],rem(N+1,2)/2,1); %Direct form
    else
      error('del is invalid')
    end
  else
    if strcmp(del,'r')
      m=fidmodel('z^-1',[0,1,zeros(1,N-1),-1],N*[1,-1],0,1); %Summed form  
    elseif strcmp(del,'f')
      m=fidmodel('z^-1',[0,1,zeros(1,N-1),-1],N*[zeros(1,(N+1)/2),1,-1],0,1); %Summed form  
    else
      error('del is invalid')
    end
  end
elseif strcmp(typ,'d')
  if ~exist('d'), d=1; end
  d=yesinput('Ksleltets, d',d,[1,inf]);
  m=fidmodel('z^-1',[0,1,zeros(1,d-1),-1],[1],0,1);  
elseif strcmp(typ,'f')
  if ~exist('nums'), nums='[0.5,-0.5]'; end
  nums=yesinput('Szmll, [b1,b2,...] vektorknt, x(n)=b1*y(n-1)... alapjn',nums);
  num=[0,str2num(nums)];
  m=fidmodel('z^-1',num,[1],0,1);  
elseif strcmp(typ,'e')
  if ~exist('Q'), Q=4; end
  Q=yesinput('Oszt, Q',Q,[1,inf]);
  m=fidmodel('z^-1',[0,1],[Q,-(Q-1)],0,1);  
end
Hzm1=tf(m); Hz=Hzm1; set(Hz,'variable','z'); 

[H,w]=freqz(Hzm1.num{1},Hzm1.den{1},256,'whole');
f=w/2/pi;
%
figure(1)
plot(f,abs(H)), title('Amplitd'), shg
if strcmp(typ,'e')
  [H3,ind]=min(abs(abs(H)-1/sqrt(2)));
  hold on, plot([0,f(ind)*[1,1]],[abs(H(ind))*[1,1],0],':'), hold off
end
if ~isequal(printfigs,0), print -djpeg de-fig1.jpg, end
zoom on
%
figure(2)
Hphi=(angle(H*exp(-j*1e-8))+1e-8)/2/pi*360;
plot(f,Hphi), title('Fzis (+-180 fok kztt)')
hold on
plot([min(f),max(f)],180*[1,1],':')
plot([min(f),max(f)],0*[1,1],':')
plot([min(f),max(f)],-180*[1,1],':')
hold off
shg
if ~isequal(printfigs,0), print -djpeg de-fig2.jpg, end
zoom on
%
figure(3)
phi=unwrap(Hphi*2*pi/360)/2/pi*360;
plot(f,phi), title('Folytonos fzis')
for ph=180-[0:5]*360
  if (ph<max(phi))&(ph>min(phi))
    hold on, plot([min(f),max(f)],ph*[1,1],':'), hold off
  end
end
shg
if ~isequal(printfigs,0), print -djpeg de-fig3.jpg, end
zoom on
%
figure(4)
pzmap(Hzm1)
t=[0:100]/100;
ax=findobj(gcf,'type','axes','xlim',[-1,1]);
if ~isempty(ax)
  set(ax,'nextplot','add')
  plot(sin(2*pi*t),cos(2*pi*t),'parent',ax,'linewidth',0.1)
  set(ax,'nextplot','replacechildren')
end
zerov=zero(Hzm1), polev=pole(Hzm1)
hL=[findall(4,'Marker','x');findall(4,'Marker','o')];
if ~isempty(hL)
  hpL=get(hL,'parent');
  if iscell(hpL), hpL=cat(1,hpL{:}); end
  hp=median(hpL); 
  if ~ishandle(hp), hp=hpL(1); end
  set(hp,'PlotBoxAspectRatio',[1 1 1],'DataAspectRatioMode','auto')
  if sum([polev;inf]==0)>1
    text(0.05,0.05,sprintf('%.0fx',sum(polev==0)),'parent',hp)
  elseif sum([zerov;inf]==0)>1
    text(0.05,0.05,sprintf('%.0fx',sum(zerov==0)),'parent',hp)
  end
end
if ~isequal(printfigs,0), print -djpeg de-fig4.jpg, end
zoom on
figure(1)
disp(' ')
disp('tviteli fggvny a (z^-1)-tartomnyban:')
Hzm1
disp(' ')
disp('tviteli fggvny a z-tartomnyban:')
Hz
