%HPQUAN Quantization in the HP3582A spectrum analyzer
%
hold off, clf, clear
if exist('lan')~=1, lan=2; end
%lan=yesinput('Your choice',lan,[1,3]);

maxs=256;
p=1:maxs;
ps=0:maxs-1;
pl=[ps(:)';p(:)'];pl=pl(:);
x0=zeros(maxs,1);
t=-maxs/2:1:maxs/2-1;
xl=(t/4.096)/2;
x1=[xl(:)';xl(:)'];x1=x1(:);
x2=5.6*sin(10*t);
a=[1 maxs -5.6 5.6];axis(a);
subplot(111);
plot(p,x0,'-',pl,x1,'-',p,x2,'.k','markersize',0.1);
if  lan==1        title('Fragment of the 12 bit uniform quantizer and the dither');
  xlabel('Time, ms');ylabel('Amplitude')
elseif lan==2 title('A 12-bites egyenletes kvantl rszlete a ditherrel');
  xlabel('Id, ms');ylabel('Amplitd')
else           title('A 12-bites egyenletes kvantalo reszlete a ditherrel');
  xlabel('Ido, ms');ylabel('Amplitudo')
end
ax=axis; ax([3:4])=[-10,10]; axis(ax)
zoom on
shg, pause;clf;

f=ones(500,1);
fc=zeros(250,1);
f(251:500)=fc(1:250);
f(270)=2;
a=[1 50 -1 2.5];axis(a);
ff=0.1:.1:50;
stairs(ff,f);
if lan==1        title('Frequency limit: 25 kHz, frequency of the dither: 27 kHz');
  xlabel('Frequency, kHz');ylabel('Amplitude')
elseif lan==2 title('Hatrfrekvencia: 25 kHz, dither frekvencija: 27 kHz ');
  xlabel('Frekvencia, kHz');ylabel('Amplitd')
else           title('Hatarfrekvencia: 25 kHz, dither frekvenciaja: 27 kHz');
  xlabel('Frekvencia, kHz');ylabel('Amplitudo')
end;
ax=axis; ax([3:4])=[0,2.2]; axis(ax)
shg, pause;

tt=1:2*maxs;
x=5.6*sin(tt*1.6566);
a=[0 2*maxs -6.5 6.5];
axis(a);
subplot(2,1,1);
plot(x);
if  lan==1        title('Sinusoidal dither in the time domain');
  xlabel('Time, ms');ylabel('Amplitude')
elseif lan==2 title('A szinuszos dither idfggvnye');
  xlabel('Id, ms');ylabel('Amplitd')
else           title('A szinuszos dither idofuggvenye');
  xlabel('Ido, ms');ylabel('Amplitudo')
end
shg, pause
xlabel('')
subplot(2,1,2)
qvan=0.244;
for i=1:2*maxs tr1=x(i)/qvan;
  tr2=fix(tr1); 
  if tr1>0
    if (tr1-tr2>=0.5) y(i)=(tr2+1)*qvan;
    else              y(i)=tr2*qvan;end;
  else 	 
    if (tr1-tr2<=-0.5) y(i)=(tr2-1)*qvan;
    else               y(i)=tr2*qvan;end;
  end;   
end;
stairs(y);		 
if  lan==1         title('Quantized dither');
  xlabel('Time, ms');ylabel('Amplitude')
elseif lan==2 title('A kvantlt dither');
  xlabel('Id, ms');ylabel('Amplitd')
else           title('A kvantalt dither');
  xlabel('Ido, ms');ylabel('Amplitudo')
end;
shg, pause;clf;

er=x-y;
a=[0 2*maxs -.15 .15];axis(a);
clf
stairs(er);
if  lan==1         title('Quantization error in the time domain');
  xlabel('Time, ms');ylabel('Amplitude')
elseif lan==2 title('A kvantlsi hiba idfggvnye');
  xlabel('Id, ms');ylabel('Amplitd')
else           title('A kvantalasi hiba idofuggvenye');
  xlabel('Ido, ms');ylabel('Amplitudo')
end;
axis;  
poz1=-0.3:0.006:0.3;
hist(er,poz1);
if lan==1
  title('Probability density function of the quantization error');
  xlabel('Amplitude');ylabel('')
elseif lan==2 
  title('A kvantlsi hiba valsznsg-srsgfggvnye');
  xlabel('Amplitd'), ylabel('Relatv gyakorisg')
else
  title('A kvantalasi hiba valoszinuseg-surusegfuggvenye');
  xlabel('Amplitudo');ylabel('')
end;
shg, pause;clf;

clear ps xl x0 x1 x2 f fc y ;
X=fft(x);
p=100*(0:2*maxs-1)/(2*maxs);
lineplot(p,abs(X));
a=[0 2*maxs/10 0 250];axis(a);
if lan==1        title('Spectrum of the dither');
  xlabel('Frequency, kHz');ylabel('Amplitude')
elseif lan==2 title('A dither spektruma');
  xlabel('Frekvencia, kHz');ylabel('Amplitd')
else           title('A dither spektruma');
  xlabel('Frekvencia, kHz');ylabel('Amplitudo')
end
pause

Y=fft(er);
YY=Y.*conj(Y);
lineplot(p,abs(Y));
a=[0 2*maxs/10 0 10];axis(a);
if lan==1        title('Enlarged spectrum of the quantization error');
  xlabel('Frequency, kHz');ylabel('Amplitude')
elseif lan==2 title('A kvantlsi hiba nagytott spektruma');
  xlabel('Frekvencia, kHz');ylabel('Amplitd')
else           title('A kvantalasi hiba nagyitott spektruma');
  xlabel('Frekvencia, kHz');ylabel('Amplitudo')
end;
shg, pause;clf;

a=[1 2*maxs -6 6];axis(a);
pp=1:2*maxs;
xs=0.178*sin(tt/10);
plot(pp,x,'-',pp,xs,'-');
if  lan==1        title('Min. detectable signal (-75dB) and the dither (-45dB)');
  xlabel('Time, ms');ylabel('Amplitude')
elseif lan==2 title('A min. detektlhat jel (-75dB) s a dither (-45dB)');
  xlabel('Id, ms');ylabel('Amplitd')
else           title('A min. detektalhato jel (-75dB) es a dither (-45dB)');
  xlabel('Ido, ms');ylabel('Amplitudo')
end;
shg, pause;clf;

Xs=fft(xs);
XX=Xs.*conj(Xs);
plot(pl,20*log10(abs(YY)),'-',pl,20*log10(abs(XX)),'-');
a=[0 2*maxs/2 -50 70]; 
axis(a);
if lan==1
  title('Measured spectrum with suppressed dither');
  xlabel('Frequency, kHz');ylabel('Amplitude')
elseif lan==2 title('A mrt spektrum elnyomott ditherrel');
  xlabel('Frekvencia, kHz');ylabel('Amplitd')
else           title('A mert spektrum elnyomott ditherrel');
  xlabel('Frekvencia, kHz');ylabel('Amplitudo')
end;
shg
%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF HPQUAN %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
