%INTERPFFT  Interpolci fft-vel
%
%    Data file: minti.mat

hold off, close all, clear
ok='y'; 
if ~exist('num'), num=1; end
maxm=256; %eredeti mintk szma
actm=32; %j mintk szma
load minti;

if exist('lan')~=1, lan=2; end
%lan=mtdemo_wrapper('yesinput','Your choice',lan,[1,3]);
clc;

while ok=='y'
  if lan==1 fprintf('Which signal do you want to analyse?(1..8)');
    num=mtdemo_wrapper('yesinput','Your choice',num,[1,8]);
  elseif lan==2 fprintf('Melyik jelet kvnja analizlni?(1..8)');
    num=mtdemo_wrapper('yesinput','Mit vlaszt',num,[1,8]);
  else fprintf('Melyik jelet kivanja analizalni?(1..8)');
    num=mtdemo_wrapper('yesinput','Mit valaszt',num,[1,8]);
  end
  eval(['mint=mint',num2str(num),';'])
  
  minit=min(mint); maxit=max(mint); d=maxit-minit;
  minit=minit-0.3*d; maxit=maxit+0.3*d;
  if minit>0, minit=-0.1*d; end
  minif=0; maxif=1*actm/maxm;

  o=0:maxm-1;
  oo=0:maxm/actm:maxm-1;
  
  subplot(2,1,1);
  plot(o,mint,'-');
  a=[0 maxm minit maxit];
  axis(a);
  if  lan==1     title('Signal in the time domain');
    xlabel('Time, ms');ylabel('Amplitude')
  elseif lan==2 title('Az idtartomnybeli jel');
    xlabel('Id, ms');ylabel('Amplitd')
  else       
    title('Az idotartomanybeli jel');
    xlabel('Ido, ms');ylabel('Amplitudo')
  end
  xlabel('')
  
  m(1:actm)=mint(maxm/actm*(0:actm-1)+1);
  subplot(2,1,2)
  lineplot(oo,m,'-');
  a=[0 maxm minit maxit];
  axis(a);
  if  lan==1     title('Sampled signal in the time domain');
    xlabel('Time, ms');ylabel('Amplitude')
  elseif lan==2 title('A mintavtelezett idfggvny');
    xlabel('Id, ms');ylabel('Amplitd')
  else        title('A mintavetelezett idofuggveny');
    xlabel('Ido, ms');ylabel('Amplitudo')
  end;
  figure(gcf)
  pause
  clf;
  
  X=fft(m);
  foo=[0:length(oo)-1]/length(oo)*actm/maxm;
  fo=[0:length(o)-1]/length(o);
  clf
  subplot(2,1,1);
  lineplot(foo,abs(X),'-');
  a=[0 max(fo) 0 1.2*max(abs(X(2:end)))];
  axis(a);
  if lan==1     title('Absolute value of the DFT');
    xlabel('Frequency, kHz');ylabel('Amplitude')
  elseif lan==2 title('DFT abszolt rtke');
    xlabel('Frekvencia, kHz');ylabel('Amplitd')
  else        title('DFT abszolut erteke');
    xlabel('Frekvencia, kHz');ylabel('Amplitudo')
  end;
  pause
  
  Y=zeros(maxm,1);
  Y(1:actm/2)=X(1:actm/2);
  Y(maxm+1-[1:actm/2])=X(actm+1-[1:actm/2]);
  subplot(2,1,2)
  lineplot(fo,abs(Y),'-');
  a=[0 max(fo) 0 1.2*max(abs(X(2:end)))];
  axis(a);
  if lan==1     title('Spectrum with zeros inserted for interpolation');
    xlabel('Frequency, kHz');ylabel('Amplitude')
  elseif lan==2 title('A nullkkal kiegsztett spektrum');
    xlabel('Frekvencia, kHz');ylabel('Amplitd')
  else        title('A nullakkal kiegeszitett spektrum');
    xlabel('Frekvencia, kHz');ylabel('Amplitudo')
  end;
  figure(gcf),pause;clf;
  
  subplot(2,1,1);
  lineplot(oo,m,'-');
  a=[0 maxm minit maxit];
  axis(a);
  if  lan==1     title('Sampled signal in the time domain');
    xlabel('Time, ms');ylabel('Amplitude')
  elseif lan==2 title('A mintavtelezett idfggvny');
    xlabel('Id, ms');ylabel('Amplitd')
  else
    title('A mintavetelezett idofuggveny');
    xlabel('Ido, ms');ylabel('Amplitudo')
  end;
  pause

  mm=ifft(Y)*maxm/actm;
  lineplot(o,real(mm),'-')
  a=[0 maxm minit maxit];
  axis(a);
  hold on
  plot(o,real(mint),'-');
  hold off
  if  lan==1
    title('Original and interpolated signal in the time domain');
    xlabel('Time, ms');ylabel('Amplitude')
  elseif lan==2 title('Az eredeti s az interpolcival visszalltott jel');
    xlabel('Id, ms');ylabel('Amplitd')
  else
    title('Az eredeti es az interpolacioval visszaallitott jel');
    xlabel('Ido, ms');ylabel('Amplitudo')
  end;
  figure(gcf)
  zoom on
  num=num+1;
  if num==9 
    ok='n';
  else
    pause
  end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%% END of INTERP %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%