%JELISM  A jelismtls s a mintavtelezs kapcsolata

clear, close all
if exist('lan')~=1, lan=2; end
load trans, trans=trans(:); trans=trans(1:3:length(trans));
l=length(trans);
plot(trans,'-b'), hold on
plot(trans,'.'), hold off
ax=axis; ax(2)=l; axis(ax)
if lan==1
  title('Transient signal')
else
  title('Tranziens jel')
end
shg
T=abs(fft(trans));
pause
%txtpause('p')
if ~exist('k'), k=[]; end, if isempty(k), k=1; end
while k>0
  if lan==1
    fprintf('Possibilities:\n')
    fprintf('1. 4 periodic repetitions\n')
    fprintf('2. 4 almost periodic repetitions\n')
    fprintf('3. 4.x periodic repetitions\n')
    fprintf('4.x almost periodic repetitions\n')
    k=yesinput('Your choice',k,[1,4]);
  else
    fprintf('Lehetsgek:\n')
    fprintf('1. 4 periodikus ismtls\n')
    fprintf('2. 4 majdnem periodikus ismtls\n')
    fprintf('3. 4.x periodikus ismtls\n')
    fprintf('4.x majdnem periodikus ismtls\n')
    k=yesinput('Vlaszts',k,[1,4]);
  end
  x=zeros(4*length(trans),1); ztrans=zeros(size(trans));
  if k==1
    x=[trans;trans;trans;trans];
    if lan==1
      titlstr=sprintf('4 periodic repetitions');
    else
      titlstr=sprintf('4 periodikus ismtls');
    end
  elseif k==2
    m=round(0.03*l);
    x=[trans;ztrans;trans;trans];
    x(m+l+[1:l])=x(m+l+[1:l])+trans;
    if lan==1
      titlstr=sprintf('4 almost periodic repetitions');
    else
      titlstr=sprintf('4 majdnem periodikus ismtls');
    end
  elseif k==3
    n=round(-0.01*l);
    x(1:l)=trans;
    x(n+l+[1:l])=x(n+l+[1:l])+trans;
    x(2*n+2*l+[1:l])=x(2*n+2*l+[1:l])+trans;
    x(3*n+3*l+[1:l])=x(3*n+3*l+[1:l])+trans;
    ind=4*n+4*l+1:length(x);
    if ~isempty(ind), x(ind)=x(ind)+trans(1:length(ind)); end
    if lan==1
      titlstr=sprintf('%.3g periodic repetitions',4/(1+n/l));
    else
      titlstr=sprintf('%.3g periodikus ismtls',4/(1+n/l));
    end
  elseif k==4
    m2=round(0.03*l);
    n2=round(-0.01*l);
    x(1:l)=trans;
    x(m2+n2+l+[1:l])=x(m2+n2+l+[1:l])+trans;
    x(2*n2+2*l+[1:l])=x(2*n2+2*l+[1:l])+trans;
    x(3*n2+3*l+[1:l])=x(3*n2+3*l+[1:l])+trans;  
    ind=4*n2+4*l+1:length(x);
    if ~isempty(ind), x(ind)=x(ind)+trans(1:length(ind)); end
    if lan==1
      titlstr=sprintf('%.3g almost periodic repetitions',4/(1+n2/l)); 
    else
      titlstr=sprintf('%.3g majdnem periodikus ismtls',4/(1+n2/l));
    end
  else
    error(sprintf('k=%.3g is illegal',k))
  end
  %
  clf, hold off, plot(0:length(x)-1,x)
  ax=axis; ax(2)=length(x); axis(ax)
  hold on
  plot([l,l],[0.7*ax(4)+0.3*ax(3),ax(4)],':w')
  plot(2*[l,l],[0.7*ax(4)+0.3*ax(3),ax(4)],':w')
  plot(3*[l,l],[0.7*ax(4)+0.3*ax(3),ax(4)],':w')
  hold off
  title(titlstr), figure(gcf)
  aX=abs(fft(x));
  pause
  %
  hold off
  subplot(2,1,1)
  %plot([0,1],[0,0],':w'), hold on
  plot([0:length(T)-1]/length(T),T,'.'), hold off
  if lan==1
    title('Original amplitude spectrum')
  else
    title('Eredeti amplitd-spektrum')
  end
  ax=axis; ax(4)=1.2*max(T); ax(3)=-ax(4)/50; ax(2)=1/2; axis(ax)
  ax4=ax(4);
  %
  subplot(2,1,2)
  %plot([0,1],[0,0],':w'), hold on
  plot([0:length(aX)-1]/length(aX),aX,'.'), hold off
  ax=axis; ax(4)=ax4*4; ax(3)=-ax(4)/50; ax(2)=1/2; axis(ax)
  zoom on
  shg
  %
  k=k+1; if k>4, k=0; end
  if k>0, pause, end
end
