%MEANVAR  A szmtani kzp variancijnak viselkedse

if exist('lan'), lan=2; end
sigma2=1;
if ~exist('typ'), typ='e'; end
if lan==1
  disp('Possibilities: e (exponential), b (bandlimited).')
  typ=yesinput('Type of the autovariance function, e/b',typ,'e|b');
else
  disp('Lehetsgek: e (exponencilis), b (svkorltozott).')
  typ=yesinput('Az autokovariancia fggvny tpusa, e/b',typ,'e|b');
end
if strcmp(typ,'e')
  if lan==1
    T0=yesinput('Time constant',1);
  else
    T0=yesinput('Idlland',1);
  end
elseif strcmp(typ,'b')
  if lan==1
    B=yesinput('Bandlimit',1);
  else
    B=yesinput('Svkorlt',1);
  end
end
if lan==1
  T=yesinput('Record length',50);
  N=yesinput('Maximum number of samples',300);
else
  T=yesinput('A regisztrtum idtartama',50);
  N=yesinput('A mintk max. szma',300);
end
vm=zeros(1,N); C0=sigma2;
for ii=1:N  
  dt=T/ii; tau=[1:ii]*dt;
  if strcmp(typ,'e')
    C=sigma2*exp(-tau/T0);
  elseif strcmp(typ,'b')
    C=sigma2*sin(2*pi*tau*B)./(2*pi*tau*B);
  end
  vm(ii)=C0/ii+2/ii*sum((1-[1:ii]/ii).*C);
end
Nv=[1:N];
loglog(Nv,vm,'.',Nv,vm), grid on
xlabel('N'), ylabel('var{xm}')
if strcmp(typ,'e')
  if lan==1
    title('Variance for exponential covariance')
  else
    title('Variancia: exponencilis kovariancia-fggvny')
  end
elseif strcmp(typ,'b')
  if lan==1
    title('Variance for bandlimited autocorrelation')
  else
    title('Variancia: svkorltozott kovariancia-fggvny')
  end
end
figure(gcf)

%ylabel(''), title('')
%print -deps \digit\figs\varfugg.eps
