%QUANTDEM  Kvantlt jel demonstrcija

if ~exist('sig'), sig='s'; end
sig=yesinput('Jeltpus, szinusz vagy zaj, s/n',sig,'s|n');
if ~exist('Nq'), Nq=8; end
Nq=yesinput('A kvantumszintek szma',Nq,[2,inf]);
if ~exist('N'), N=1024; end
N=yesinput('Mintk szma',N,[2,inf]);

t=[1:1.2*N]';
if strcmp(sig,'s'), x=sin(2*pi*(t/N+rand));
elseif strcmp(sig,'n')
  x=randn(size([t;t]));
  x=conv(x,ones(1,N/2));
  x=x(N/2+[1:length(t)]);
  x=x/max(abs(x));
end

close all
clf, zoom off
subplot(2,1,1)
plot(t,x)
set(gca,'xlim',[0,max(t)])
ysc=[-1.2,1.2];
set(gca,'ylim',ysc)

q=2/Nq;
xq=q*round(x/q);
hold on
plot(t,xq,'.','markersize',1)
title('A bemen jel s kvantlt vltozata')
hold off

qt=xq-x;
h=subplot(2,1,2);
plot(t,qt,'.','markersize',1)
set(gca,'xlim',[0,max(t)])
set(gca,'ylim',ysc)
title('Kvantlsi hiba')
zoom on
figure(gcf)
pause

clf
hist(qt,20)
title('A kvantlsi hiba srsgfggvnye')
figure(gcf)
pause

NQ=fft(xq-x);
clf
f=[0:length(t)-1]'/(length(t)-1);
plot(f,abs(NQ.^2),'.','markersize',6)
title('A kvantlsi hiba teljestmnysrsg-spektruma')
zoom on
figure(gcf)
