function w = RIFEV2(R,M,n)
%RIFEV2 Rife-Vincent window, class II
%     rifev2(R,M,n)
%    This function returns n points of Class II
%    Rife-Vincent window.The parameter M defines the
%    order of the window,R defines the maximum side-
%    lobe level (1/R).

R = 10.^(-R/20);
l = 1/pi*log(R+sqrt(R.^2-1));
d1 = ones(M,1);
d2 = ones(M,1);
for i=M:-1:1
  s = ((i+1).^2)/(l.^2+(i+.5).^2);
  for j=1:i
    d1(i) = d1(i)*(1-((i/s).^2/(l.^2+(j-.5).^2)));
    if i~=j  d2(i) = d2(i)*(1-(i/j).^2); end
  end;
end;
D = -d1./d2;
for i=0:n-1
  w(i+1)=1;
  for j=1:M
    w(i+1)=w(i+1)+D(j)*cos(2*pi*j*i/n);
  end;
end
