function windows(num)
%WINDOWS  Az alapvet ablakok illusztrcija
%Utols javts: 2001. szept. 29, KI

if nargin==0, num=[]; end
wins={'Ngyszg';...
    'Hann';...
    'Hamming';...
    'Blackman (DC + 3 komponens)';...
    'Flat Top (DC + 4 komponens)';...
    'sszes'};
if ~isempty(num), wins=wins(num); end

N=4*1024; Wtot=[];
for ii=1:length(wins)
  if strcmp(wins{ii},'Ngyszg')
    if exist('rectwin'), w=rectwin(N);
    else w=boxcar(N);
    end
    c=1;
  elseif strcmp(wins{ii},'Hann')
    if exist('hann'), w=hann(N);
    else w=hanning(N);
    end
    c=2;
  elseif strcmp(wins{ii},'Hamming')
    w=hamming(N); c=2;
  elseif strncmp(wins{ii},'Blackman',8)
    if exist('nuttallwin')&0, w=nuttallwin(N);
    else w=blackman(N);
    end
    c=4;
  elseif strncmp(wins{ii},'Flat Top',8)
    w=flattop(N); c=5;
  elseif strncmp(wins{ii},'sszes',6)
    w=[];
  else
    error('Unknown window')
  end
  if ~isempty(w)
    w=w/mean(w);
    x=32; Nl=x*N;
    wl=zeros(length(w)*x,1); wl(1:N)=w;
    W=fft(wl)/N; f=[0:Nl-1]/Nl; ind=1:N;
  end
  if ~any(findstr('sszes',wins{ii}))
    ht=figure(1);
    plot(w)
    title([wins{ii},sprintf(' ablak, N=%.0f',N),', idtartomny'])
    shg
    hf=figure(2);
    plot(f(ind),abs(W(ind)))
    title([wins{ii},' ablak, frekvenciatartomny'])
    Wtot=[Wtot;abs(W(ind(2:end)))'];
    shg
    hflog=figure(3);
    semilogx(f(ind(2:end)),20*log10(abs(W(ind(2:end)))))
    title([wins{ii},' ablak, frekvenciatartomny'])
    axis([1e-4,3e-2,-110,0])
    ylabel('dB')
    zoom on
    shg
    A=real(W(1:x:c*x));
    yp=0.65;
    for ic=1:c
      h=text(0.1,yp-ic*0.07,sprintf('A%.0f=%.5g',ic-1,A(ic)),'sc');    
      set(h,'fontsize',10)
    end %for ic
  else
    hflog=figure(3);    
    semilogx(f(ind(2:end)),20*log10(abs(Wtot)))
    title([wins{ii},' ablak, frekvenciatartomny'])
    axis([1e-4,3e-2,-110,0])
    ylabel('dB')
    zoom on
    shg
  end
  if ii<length(wins)
    pause
  end
end %for ii
