;*******************************************************************************
;*  4 x 4 bites eljel nlkli tmbszorz.                                     *
;*                                                                             *
;* A tmbszorz megvalstsa:                                                 *
;*                                                                             *
;*      1001 * 0110                                                            *
;*   -------                                                                   *
;*      0000 = (1001 & 0000) << 0                                              *
;*     10010 = (1001 & 1111) << 1                                              *
;*    100100 = (1001 & 1111) << 2                                              *
;*  +0000000 = (1001 & 0000) << 3                                              *
;*  --------                                                                   *
;*  00110110                                                                   *
;*                                                                             *
;* A megvalstsnl a papr-ceruza mdszert hasznljuk. A rszszorzatokat     *
;* megkapjuk a szorzandnak s a szorz egyes bitjeinek S kapcsolataknt,     *
;* melyet el kell shiftelni balra a szorz adott helyirtknek megfelel      *
;* szm bittel. Ezutn ssze kell adni az egyes rszszorzatokat.              *
;*******************************************************************************
DEF LD  0x80                ; LED regiszter          (rhat/olvashat)
DEF SW  0x81                ; DIP kapcsol regiszter (csak olvashat)

    CODE

;*******************************************************************************
;* A program kezdete. A programmemria 0x00 s a 0x01 cme a reset, illetve    *
;* a megszakts vektor. Ide ugr utastsokat kell elhelyezni, amelyek a      *
;* megfelel programrszre ugranak. Ha nem hasznlunk megszaktst, akkor a    *
;* program kezddhet a 0x00 cmen is.                                          *
;*******************************************************************************
start:
    mov     r0, SW          ; Beolvassuk a kapcsolk llapott.
                            ; SW[7:4] = Szorzand   SW[3:0] = Szorz  
    mov     r1, r0          ; A szorzt (SW[3:0]) az r1 regiszterbe msoljuk
    and     r1, #0x0f       ; s nullzzuk a fels 4 bitet.
    and     r0, #0xf0       ; Az als biteket nullzva r0 tarlmazza a szorzandt.
	sr0     r0              ; Ezt jobbra shiftelve rendelkezsre ll az els 
                            ; rszszorzat (ha gy kezdjk, jobb az algoritmus). 
    mov     r2, #0          ; r2 elksztse a szorzat trolsra
                            ; A szorzst ciklusokban vgezzk el, r2-ben 
                            ; folyamatosan akkumlljuk a rszszorzat sszegeket  
    mov     r3, #4          ; A 4 bites szorzshoz a ciklust inicializljuk
mul_loop:
    tst     r1, #0x08       ; Megvizsgljuk a szorz legnagyobb helyirtk
    jz      no_add          ; bitjt. Ha 0, akkor nem kell a rszszorzatsszegzs
    add     r2, r0          ; Hozzadjuk a rszszorzatot az r2 regiszterhez.
no_add:
    sr0     r0              ; A szorzandt jobbra kell shiftelni, hogy
                            ; megkapjuk a kvezkez rszszorzatot.
    sl0     r1              ; A szorzt balra kell shiftelni, hogy a
                            ; kvetkez vizsgland bit a 3. bitpoziciba kerljn.
    sub     r3, #1          ; Cskkentjk a ciklusvltozt.
    jnz     mul_loop        ; Ha nem nulla mg, akkor visszaugrs.

    mov     LD, r2          ; A szorzatot megjelentjk a LED-eken.
    jmp     start           ; Ugrs a program elejre.
