function net = decode_chr2netw(x, net_in, layers, sp, st)
% -------------------------------------------------
% CLASSICAL GENETIC ALGORITHM
% decode_chr2netw - convert chromosomes corresponding
%                   to neural network weights/biases
%                   into Neural Networks Toolbox v6 form
%
% Made by:
% Daniel L. Kovacs
% <dkovacs@mit.bme.hu>
%
% Department of Measurement and Information Systems
% Faculty of Electrical Engineering and Informatics
% Budapest University of Technology and Economics
% 
% January 2010
% -------------------------------------------------

try
    
    % Initialize output variables
    net = net_in;
    
	% -----------------------------------------------------------------------------------------------------------------------------
    % -------------------------------------------------------- INPUT CHECK --------------------------------------------------------
    % -----------------------------------------------------------------------------------------------------------------------------
    
    % ...we don't do anything here for performance reasons (because this method is
    % called a "million" times...:) ...let us believe that the input is
    % right at this level of execution!
        
    % --------------------------------------------------------------------------------------------------------------------------------
    % -------------------------------------------------------- FUNCTION BODY  --------------------------------------------------------
    % --------------------------------------------------------------------------------------------------------------------------------
    
    % The number of hidden layers (not including the output layer)
    l                   = size(layers, 2);
    
    % Lets divide x into sections corresponding to layers (weight matrix +
    % bias vector). The length of the first section is b (see below), and
    % thus the first section is x(1:b). Now we take this section, cut it
    % out, reshape it into an m=[IW{1,1},b{1}] matrix with the appropriate
    % size, and then put IW{1,1} and b{1} into the neural network object...
    b                   = (1 + sp) * layers(1);   
    m                   = reshape(x(1:b), layers(1), (1 + sp));
    % m                   = reshape(x(1:b), (1 + sp), layers(1))';
    
    net.IW{1,1}         = m(:, 1:sp);
    net.b{1}            = m(:, 1+sp);
    
    % After the 1st layer (IW) which connects the 1st hidden layer with the
    % inputs, we can continue with other hidden layers (if any) the way we
    % did before. Now instead of IW{1,1} there will be LW{i,i-1}, the
    % weight matrix of the i-th hidden layer (see. the reference of the
    % Neural Network Toolbox for more details).
	for i=2:l,
        
        a               = b;
        b               = b + (1 + layers(i-1)) * layers(i);       
      	m               = reshape(x(a+1:b), layers(i), (1 + layers(i-1)));
        % m               = reshape(x(a+1:b), (1 + layers(i-1)), layers(i))';
        
        net.LW{i,i-1}	= m(:, 1:layers(i-1));
        net.b{i}        = m(:, 1+layers(i-1));

	end
    
    % ...and after all the hidden layers were done, we should excavate the
    % appropriate values from x for the last output layer, which is
    % "connected" to the targets of the neural network.
    a                   = b;
    b                   = b + (1 + layers(l)) * st;
 	m                   = reshape(x(a+1:b), st, (1 + layers(l)));
    % m                   = reshape(x(a+1:b), (1 + layers(l)), st)';
    
 	net.LW{l+1,l}       = m(:, 1:layers(l));
 	net.b{l+1}      	= m(:, 1+layers(l));

catch
   
	% Catch and display the last error or an exception thrown above
	err = lasterror;
	disp(err.message);
   
end