function fval = f_binary(x, params)
% -------------------------------------------------
% CLASSICAL GENETIC ALGORITHM
% f_binary - calculate the binary value of chromosomes
%
% Made by:
% Daniel L. Kovacs
% <dkovacs@mit.bme.hu>
%
% Department of Measurement and Information Systems
% Faculty of Electrical Engineering and Informatics
% Budapest University of Technology and Economics
% 
% January 2010
% -------------------------------------------------

try
    
    % Initialize variables
    [k, n]  = size(x);
    fval	= zeros(k, 1);

	% -----------------------------------------------------------------------------------------------------------------------------
    % -------------------------------------------------------- INPUT CHECK --------------------------------------------------------
    % -----------------------------------------------------------------------------------------------------------------------------
    
    % Check input variable 1/2
	if  isempty(x),                                         	% IF the matrix of individuals (x) is empty, THEN...
       
        throw(MException('MATLAB:f_binary:x',...
                         'Input error (1/2): the matrix of individuals should not be empty'));
        
	end
    
    % Check input variable 2/2
	if  ~isempty(params) &&...                                  % IF the input parameters struct is not empty (is given), AND...
        isfield(params, 'range') &&...                          % it has a "range" field, AND...
        (~all(eq(size(params.range), [1, 2])) ||...             % the "range" field is not a 1*2 row-vector, OR...
        ~(params.range(2) > params.range(1))),                  % its 2nd element is not greater, than the 1st, THEN...                                                      
       
        throw(MException('MATLAB:f_binary:params.range',...
                         'Input error (2/2): the range field input of the fitness function should be an 1*2 row-vector [A,B] with A > B'));
        
	end
    
    % --------------------------------------------------------------------------------------------------------------------------------
    % -------------------------------------------------------- FUNCTION BODY  --------------------------------------------------------
    % --------------------------------------------------------------------------------------------------------------------------------

    % Calculate the decimal value of every binary row vector of x
    fval = x * power(2*ones(n, 1), linspace(n-1, 0, n)');
	% for i=1:k,
    %     for j=1:n,
    %         fval(i) = fval(i) + (x(i, j) * 2^(n - j));
    %     end
    % end

    if  ~isempty(params) &&...                                  % IF the input parameters struct is not empty (is given), AND...
        isfield(params, 'range'),                               % it has an appropriate "range" field, THEN...
    
        % Normalize the fitness to [0..1]
        fval = fval / (params.range(2) - params.range(1));
    
    end
  
catch
   
	% Catch and display the last error or an exception thrown above
	err = lasterror;
	disp(err.message);
   
end