function fval = f_neuralw(x, params)
% -------------------------------------------------
% CLASSICAL GENETIC ALGORITHM
% f_neuralw - calculate the fitness value of chromosomes
%             corresponding to neural network weights/biases
%
% Made by:
% Daniel L. Kovacs
% <dkovacs@mit.bme.hu>
%
% Department of Measurement and Information Systems
% Faculty of Electrical Engineering and Informatics
% Budapest University of Technology and Economics
% 
% January 2010
% -------------------------------------------------

try
    
    % Initialize variables
    k       = size(x, 1);
    fval	= zeros(k, 1);

	% -----------------------------------------------------------------------------------------------------------------------------
    % -------------------------------------------------------- INPUT CHECK --------------------------------------------------------
    % -----------------------------------------------------------------------------------------------------------------------------
    
    % Check input variable 1/2
	if  isempty(x),                                         	% IF the matrix of individuals (x) is empty, THEN...
       
        throw(MException('MATLAB:f_neuralw:x',...
                         'Input error (1/2): the matrix of individuals should not be empty'));
        
	end
    
    % Check input variable 2/2
	if  isempty(params) ||...                               	% IF the input parameters struct is empty, OR...
        ~isfield(params, 'p') ||...                           	% it hasn't got a "p" field (neural inputs), OR...
        ~isfield(params, 't') ||...                             % it hasn't got a "t" field (neural targets), OR...
        ~isfield(params, 'layers') ||...                     	% it hasn't got a "layers" field (hidden layers' neuron number), OR...
        ~isfield(params, 'net') ||...                           % it hasn't got a "net" field (a neural network structure), OR...
        isempty(params.p) ||...                               	% the "p" field is empty, OR...
        isempty(params.t) ||...                               	% the "t" field is empty, OR...
        isempty(params.layers) ||...                            % the "layers" field is empty, OR...
        isempty(params.net) ||...                               % the "net" field is empty, OR...
        size(params.p, 2) ~= size(params.t, 2),               	% the size of "p" and "t" (the number of learning points) is not appropriate, THEN...                                                      
       
        throw(MException('MATLAB:f_neuralw:params',...
                         'Input error (2/2): neural parameters must have a non-empty "p", "t", "layers", and "net" field (inputs and outputs with the same number of columns; hidden network layers'' neuron number; neural network structure)'));
        
	end
    
    % --------------------------------------------------------------------------------------------------------------------------------
    % -------------------------------------------------------- FUNCTION BODY  --------------------------------------------------------
    % --------------------------------------------------------------------------------------------------------------------------------

    % Calculate the input/output dimensions
    sp = size(params.p, 1);
    st = size(params.t, 1);
    
    % Calculate the fitness of every individual chromosome
	for i=1:k,

        % Decode the i-th individual (chromosome) into appropriate network weights and biases 
        net = decode_chr2netw(x(i, :), params.net, params.layers, sp, st);
            
      	% Return the normalized MSE of the decoded network as fitness (if MSE = 0, then FVAL = 1; if MSE = inf, then FVAL = 0)
    	fval(i, 1)              = 1 / (1 + mse(params.t - simnet(net, params.p)));

	end
  
catch
   
	% Catch and display the last error or an exception thrown above
	err = lasterror;
	disp(err.message);
   
end