function [fp, genes, chr_length] = f_timetable_params(probnum)
% -------------------------------------------------
% CLASSICAL GENETIC ALGORITHM
% f_timetable_params - return a timetable problem
%
% Made by:
% Daniel L. Kovacs
% <dkovacs@mit.bme.hu>
%
% Department of Measurement and Information Systems
% Faculty of Electrical Engineering and Informatics
% Budapest University of Technology and Economics
% 
% March 2010
% -------------------------------------------------

try

    % Trgy(Trgy neve, Trgykd, Tanszk ID)
    fp.subject =   {'A folyamatirnyts s -tervezs gyakorlati mdszertana', 'BMEVIIIJV81', 5;...
                    'A fuzzy, neurlis s genetikus mest. intelligencia mdszerei', 'BMEVIVEJV15', 10;...
                    'A matematika matematikja', 'BMETE919215', 0;...
                    'A programozs alapjai 1.', 'BMEVIHIA106', 4;...
                    'A programozs alapjai 2', 'BMEVIAUA116', 1;...
                    'A rdihlzatok tervezsnek korszer mdszerei', 'BMEVIHVJV45', 8;...
                    'A UNIX rendszer felhasznli s fejleszti fellete', 'BMEVIIIJV76', 5;...
                    'Adatbnyszat laboratrium', 'BMEVISZA384', 7;...
                    'Adatbnyszati alkalmazsok', 'BMEVITMJV16', 9;...
                    'Adatbzisok szerver oldali programozsa', 'BMEVIAUJV59', 1;...
                    'Adatbiztonsg s tartalom alap informcikezels', 'BMEVIHIA322', 4;...
                    'Adatvdelem s informciszabadsg', 'BMEVIETAK49', 2;...
                    'Adatvezrelt alkalmazsok fejlesztse', 'BMEVIAUA369', 1;...
                    'Algoritmuselmlet', 'BMEVISZA213', 7;...
                    'Alkalmazsorientlt eszkzk mrnkknek', 'BMEVIVEAV56', 10;...
                    'Analzis 1 informatikusoknak', 'BMETE90AX04', 0;...
                    'Analzis 2 informatikusoknak', 'BMETE90AX05', 0;...
                    'Anyagtudomny', 'BMEGEMTAV01', 0;...
                    'Autonm robotok s jrmvek', 'BMEVIIIA358', 5;...
                    'Autonm robotok s jrmvek laboratrium 1.', 'BMEVIIIA361', 5;...
                    'Autvillamossg', 'BMEVIVEJV76', 10;...
                    'Az elektronikus kereskedelem alapjai', 'BMEVITMJV13', 9;...
                    'Az emberi emlkezet', 'BMEGT471004', 0;...
                    'Az optikai hlzatok alapjai', 'BMEVIHVJV71', 8;...
                    'Begyazott s ambiens rendszerek', 'BMEVIMIA347', 6;...
                    'Begyazott s ambiens rendszerek laboratrium', 'BMEVIMIA350', 6;...
                    'Begyazott funkcionlis programozs', 'BMEVIIIJV42', 5;...
                    'Begyazott informcis rendszerek', 'BMEVIMIA359', 6;...
                    'Bevezets a mobil szoftverfejlesztsbe', 'BMEVIAUAV69', 1;...
                    'Bevezets a szmtselmletbe 1.', 'BMEVISZA103', 7;...
                    'Bevezets a szmtselmletbe 2.', 'BMEVISZA110', 7;...
                    'Biofizika alapjai', 'BMETE12AF10', 0;...
                    'Biztonsgos programozs', 'BMEVIMIBV08', 6;...
                    'Budapesti ermvek', 'BMEVIVEAV87', 10;...
                    'Csoportmunka menedzsment', 'BMEVIAUJV11', 1;...
                    'Deklaratv programozs', 'BMEVISZA402', 7;...
                    'Digitlis technika 1.', 'BMEVIIIA104', 5;...
                    'Digitlis technika 1.', 'BMEVIMIA102', 6;...
                    'Digitlis technika 2.', 'BMEVIIIA108', 5;...
                    'Digitlis technika 2.', 'BMEVIMIA111', 6;...
                    'Dokumentumszerkeszts', 'BMEVIHIJV47', 4;...
                    'Dntsek informatikai tmogatsa', 'BMEVITMAV59', 9;...
                    'Eclipse alap technolgik', 'BMEVIMIAV92', 6;...
                    'Elektromgneses terek', 'BMEVIHVA204', 8;...
                    'Elektronika 1.', 'BMEVIHIA205', 4;...
                    'Elektronika 2.', 'BMEVIAUA300', 1;...
                    'Elektronikai gyrts s minsgbiztosts', 'BMEVIETA331', 2;...
                    'Elektronikus ramkrk szimulcija', 'BMEVIHVJV62', 8;...
                    'Elektronikus orvosi mszerek', 'BMEVIMIJV32', 6;...
                    'Ergonmia', 'BMEGT52A001', 0;...
                    'ERP rendszerek informcitechnolgija', 'BMEVIIIBV07', 5;...
                    'szlels', 'BMEGT471002', 0;...
                    'Fizika 1', 'BMETE11AX01', 0;...
                    'Fizika 1i', 'BMETE11AX03', 0;...
                    'Fizika 2', 'BMETE11AX02', 0;...
                    'Fizika 2i', 'BMETE11AX04', 0;...
                    'Fraktlok, kosz s diszkrt dinamikus rendszerek', 'BMETE929248', 0;...
                    'Fuzzy rendszerek I.', 'BMEVITMJV79', 9;...
                    'Gazdlkodsi informcimenedzsment', 'BMEVITMA381', 9;...
                    'Gazdasgpolitika', 'BMEGT35A003', 0;...
                    'Grafikai s animcis eszkzk', 'BMEVIAUJV21', 1;...
                    'Grafikus jtkok fejlesztse', 'BMEVIIIJV46', 5;...
                    'Hlzati technolgik s alkalmazsok', 'BMEVITMA341', 9;...
                    'Hangszerek fizikja', 'BMEVIHIJV68', 4;...
                    'Hangtechnikai gyakorlat', 'BMEVIHIJV69', 4;...
                    'Infokommunikci a kzlekedsben', 'BMEVITMJV27', 9;...
                    'Infokommunikcis hlzatok s alkalmazsok laboratrium', 'BMEVITMA343', 9;...
                    'Infokommunikcis hlzatok s szolgltatsok laboratrium 1.', 'BMEVITMA366', 9;...
                    'Infokommunikcis hlzatok tervezse s zemeltetse', 'BMEVIHIA318', 4;...
                    'Informcis rendszerek zemeltetse', 'BMEVITMA314', 9;...
                    'Informcis trsadalom', 'BMEVIMIAV65', 6;...
                    'Informatika 1', 'BMEVIIIA202', 5;...
                    'Informatika 2', 'BMEVIAUA203', 1;...
                    'Informatikai projektek menedzselse a gyakorlatban', 'BMEVITMJV17', 9;...
                    'Informatikai technolgik laboratrium 1', 'BMEVIAUA372', 1;...
                    'Intelligens rendszerek - 1 (Sensor Web s intelligens terek) laboratrium', 'BMEVIMIA360', 6;...
                    'Intelligens rendszerfelgyelet', 'BMEVIMIA370', 6;...
                    'IP alap hlzatok menedzsmentje', 'BMEVITMA365', 9;...
                    'Ipari kpfeldolgozs s kpmegjelents', 'BMEVIIIA356', 5;...
                    'Jtkfejleszts .NET plattformon', 'BMEVIAUJV01', 1;...
                    'Java-technolgia', 'BMEVIHIJV37', 4;...
                    'Jelek s rendszerek', 'BMEVIHVA214', 8;...
                    'Jelek s rendszerek 1.', 'BMEVIHVA109', 8;...
                    'Jelek s rendszerek 2.', 'BMEVIHVA200', 8;...
                    'Komplex hardvertervezs I.', 'BMEVIEEBV04', 3;...
                    'Kooperatv s tanul rendszerek', 'BMEVIMIA357', 6;...
                    'Korszer opercis rendszerek', 'BMEVIAUJV25', 1;...
                    'Krnyezetgazdasgtan', 'BMEGT42A001', 0;...
                    'Kutatsmdszertan', 'BMEGT41A002', 0;...
                    'Laboratrium 2.', 'BMEVIMIA305', 6;...
                    'Lts, nyelv, emlkezet', 'BMEGT47A001', 0;...
                    'Lptetmotoros hajtsok', 'BMEVIVEAV74', 10;...
                    'LINUX alap hlzatok', 'BMEVIAUJV60', 1;...
                    'Marketing', 'BMEGT20A002', 0;...
                    'Matematika A1a - Analzis', 'BMETE90AX00', 0;...
                    'Matematika A2a - Vektorfggvnyek', 'BMETE90AX02', 0;...
                    'Matematika A3 villamosmrnkknek', 'BMETE90AX09', 0;...
                    'Matematika A4 - Valsznsgszmts', 'BMETE90AX08', 0;...
                    'Mdiabiztonsg', 'BMEVITMA378', 9;...
                    'Mdiainformatika laboratrium 1.', 'BMEVITMA379', 9;...
                    'Mdiakommunikci', 'BMEVIHIA325', 4;...
                    'Mdiakommunikcis technolgia s rendszerek laboratrium', 'BMEVIHIA326', 4;...
                    'Mdiatechnolgik', 'BMEVIHIA321', 4;...
                    'Mdiatechnolgik laboratrium 1.', 'BMEVIHIA323', 4;...
                    'Menedzsment s vllalkozsgazdasgtan', 'BMEGT20A001', 0;...
                    'Mrs laboratrium 2.', 'BMEVIMIA216', 6;...
                    'Mrs laboratrium 4.', 'BMEVIMIA315', 6;...
                    'Mrstechnika', 'BMEVIMIA206', 6;...
                    'Mrnki menedzsment mdszerek', 'BMEVITMAK47', 9;...
                    'Mrnki problmamegolds', 'BMEVIVEAK48', 10;...
                    'Mikro- s makrokonmia', 'BMEGT30A001', 0;...
                    'Mikroelektronikai laboratrium', 'BMEVIEEA330', 3;...
                    'Mikroelektronikai tervezs', 'BMEVIEEA328', 3;...
                    'Mikrokontroller alap rendszerek', 'BMEVIAUA348', 1;...
                    'Mikrokontroller laboratrium', 'BMEVIAUA351', 1;...
                    'Mikrokontrollerek alkalmazstechnikja', 'BMEVIMIJV51', 6;...
                    'Mobil s vezetknlkli hlzatkezels Linux s *BSD opercis rendszerek alatt', 'BMEVIHIJV46', 4;...
                    'Mobil infokommunikci laboratrium 1.', 'BMEVIHIA319', 4;...
                    'Mobil infokommunikcis rendszerek', 'BMEVIHIA317', 4;...
                    'Mobil LINUX alkalmazsok', 'BMEVIAUAV74', 1;...
                    'Modulramkrk s kszlkek', 'BMEVIETA332', 2;...
                    'Monolit integrlt ramkrk ksztse', 'BMEVIEEJV55', 3;...
                    'Monolit technika', 'BMEVIEEA329', 3;...
                    'Nagyfrekvencis digitlis rendszerek komplex tervezse', 'BMEVIEEAV00', 3;...
                    'Nagyfrekvencis rendszerek', 'BMEVIHVA342', 8;...
                    'Nagyfrekvencis rendszerek s alkalmazsok laboratrium', 'BMEVIHVA344', 8;...
                    'Napelemek s megjul energiaforrsok', 'BMEVIEEAV99', 3;...
                    'Napelemek laboratrium', 'BMEVIEEBV00', 3;...
                    'Objektumorientlt szoftvertervezs', 'BMEVIIIA371', 5;...
                    'Opercis rendszerek', 'BMEVIMIA219', 6;...
                    'Pedaggia (digitlis pedaggia)', 'BMEGT51A001', 0;...
                    'Peer-to-Peer (P2P) hlzatok', 'BMEVITMJV76', 9;...
                    'Pnzgyek', 'BMEGT35A001', 0;...
                    'Programozs MS Windows alatt', 'BMEVIHVJV43', 8;...
                    'Programozhat irnytberendezsek s szenzorrendszerek', 'BMEVIIIA349', 5;...
                    'Programozhat irnytberendezsek s szenzorrendszerek laboratrium', 'BMEVIIIA352', 5;...
                    'Projektmenedzsment szoftverek a gyakorlatban', 'BMEVIHIAV95', 4;...
                    'Protokoll technolgia', 'BMEVITMA364', 9;...
                    'Pszicholgia', 'BMEGT52A002', 0;...
                    'Symbian alap szoftverfejleszts', 'BMEVIAUAV68', 1;...
                    'Szablyozstechnika', 'BMEVIIIA303', 5;...
                    'Szablyozstechnika', 'BMEVIAUA309', 1;...
                    'Szmtgp-architektrk', 'BMEVIHIA210', 4;...
                    'Szmtgpes grafika s kpfeldolgozs', 'BMEVIIIA316', 5;...
                    'Szmtgp-hlzatok', 'BMEVIHIA215', 4;...
                    'Szmtgp-hlzatok zemeltetse I.', 'BMEVIHIAV96', 4;...
                    'Szociolgia (BSc mrnk)', 'BMEGT43A002', 0;...
                    'Szoftver fejleszts .NET plattformon', 'BMEVIAUJV10', 1;...
                    'Szoftver fejleszts J2EE plattformon', 'BMEVIAUJV09', 1;...
                    'Szoftver labor 4.', 'BMEVIIIA220', 5;...
                    'Szoftver laboratrium 2.', 'BMEVIIIA115', 5;...
                    'Szoftver laboratrium 5.', 'BMEVITMA308', 9;...
                    'Szoftver-technikk', 'BMEVIAUA218', 1;...
                    'Szupravezetk alkalmazsai', 'BMEVIVEAV80', 10;...
                    'Tankri foglalkozs 2.', 'BMEVIDHTF02', 0;...
                    'Tankri foglalkozs 4.', 'BMEVIDHTF04', 0;...
                    'Tartalomkezelsi technolgik', 'BMEVITMA368', 9;...
                    'Technolgiai folyamatok s minsgellenrzsk laboratrium', 'BMEVIETA333', 2;...
                    'Termelsinformatika', 'BMEVIETA383', 2;...
                    'Testnevels - B', 'BMEGT701008', 0;...
                    'Testnevels - D', 'BMEGT701010', 0;...
                    'reszkzk fedlzeti rendszerei', 'BMEVIEEBV03', 3;...
                    'rtechnolgia', 'BMEVIHVBV06', 8;...
                    'zleti jog', 'BMEGT55A001', 0;...
                    'Vllalatirnytsi rendszerek', 'BMEVIETA382', 2;...
                    'Valsznsgszmts', 'BMEVISZA208', 7;...
                    'Villamos autk', 'BMEVIVEJV47', 10;...
                    'Villamos energetika', 'BMEVIVEA207', 10;...
                    'Villamos energetika laboratrium', 'BMEVIVEA337', 10;...
                    'Villamos energia s krnyezetvdelem', 'BMEVIVEJV81', 10;...
                    'Villamos gpek s alkalmazsok', 'BMEVIVEA334', 10;...
                    'Villamos kapcsol kszlkek', 'BMEVIVEA336', 10;...
                    'Villamosenergetikai alkalmazsok', 'BMEVIVEAV55', 10;...
                    'Villamosenergetikai nagyberuhzsok - mlt, jelen, jv', 'BMEVIVEBV12', 10;...
                    'Villamosenergia tvitel', 'BMEVIVEA335', 10;...
                    'Villmvdelem', 'BMEVIVEJV63', 10;...
                    'Vizulis illzik', 'BMEGT471013', 0;...
                    'Webportlok fejlesztse', 'BMEVIAUJV83', 1;...
                    'Zrthelyi', 'BMEVIDHZH00', 0;...
                    'Zenei jelfeldolgozs', 'BMEVIMIJV31', 6;...
                    'Informatikai technolgik laboratrium 1.', 'BMEVIMIA373', 6;...
                    'Informatikai technolgik laboratrium 1.', 'BMEVIIIA374', 5;...
                    'A programozs alapjai 2.', 'BMEVIIIA114', 5};

    % Kurzustpus(Kurzustpus neve)
    fp.coursetype ={'elads';...
                    'gyakorlat';...
                    'labor'};

    % Oktat(Oktat neve)
    fp.teacher =   {'Babarczi Pter';...
                    'Bakki Pter';...
                    'Balssy Gyrgy Mikls';...
                    'Balogh Attila';...
                    'Balogh Blint';...
                    'Bnfalvi Antal Dr.';...
                    'Bnczy Jnos dr.';...
                    'Bnysz Gbor';...
                    'Barbarics Tams Dr.';...
                    'Barta Andrs';...
                    'Bedzsula Blint Pter';...
                    'Benedek Andrs dr.';...
                    'Benedek Zoltn';...
                    'Benk Borbla Katalin';...
                    'Benk Pter Tams';...
                    'Bernyi Zsolt';...
                    'Berta Istvn Dr.';...
                    'Bilicz Sndor';...
                    'Bodon Ferenc';...
                    'Bognr Gyrgy';...
                    'Bokor rpd Dr.';...
                    'Bokor Lszl';...
                    'Bhm Tams Mihly';...
                    'Czira Zsuzsanna Dr.';...
                    'Csap Tams Gbor';...
                    'Csorba Kristf';...
                    'Csords Pter';...
                    'Csurgai Horvth Lszl';...
                    'Dady Rbert Klmn';...
                    'Dvnyi Lszl Dr.';...
                    'Dobos Gbor';...
                    'Dombi kos';...
                    'Dr. Abos Imre';...
                    'Dr. Adamis Gusztv';...
                    'Dr. Andai Attila';...
                    'Dr. Arat Pter';...
                    'Dr. Bank Balzs Lajos';...
                    'Dr. Barcsi Attila';...
                    'Dr. Bars Ruth';...
                    'Dr. Benesczky Zoltn';...
                    'Dr. Berceli Tibor';...
                    'Dr. Bit Jnos';...
                    'Dr. Bokor Nndor';...
                    'Dr. Charaf Hassan';...
                    'Dr. Cskny Rita';...
                    'Dr. Csubk Tibor';...
                    'Dr. Dabczi Tams';...
                    'Dr. Dn Andrs';...
                    'Dr. Dobrowiecki Tadeusz';...
                    'Dr. Farkas Lszl';...
                    'Dr. Fehr Bla';...
                    'Dr. Fehr Gbor';...
                    'Dr. Ferenczi Mikls';...
                    'Dr. Gajdos Sndor';...
                    'Dr. Goldschmidt Balzs';...
                    'Dr. Gordos Gza';...
                    'Dr. Gymesi Ferenc';...
                    'Dr. Hank Pter';...
                    'Dr. Hrs Gyrgy';...
                    'Dr. Harsnyi Gbor';...
                    'Dr. Henk Tams';...
                    'Dr. Hermann Imre';...
                    'Dr. Heszberger Zaln';...
                    'Dr. Hetthssy Jen';...
                    'Dr. Horvth Gbor';...
                    'Dr. Horvth Rbert';...
                    'Dr. Imre Sndor';...
                    'Dr. Ivncsy Renta Erzsbet';...
                    'Dr. Ivncsy Szabolcs';...
                    'Dr. Jeney Gbor';...
                    'Dr. Jobbgy kos';...
                    'Dr. Juhsz Sndor';...
                    'Dr. Krpti Attila';...
                    'Dr. Kiss Blint';...
                    'Dr. Kiss Istvn';...
                    'Dr. Kczy Tams Lszl';...
                    'Dr. Ksa Zsuzsanna';...
                    'Dr. Kro Andrs';...
                    'Dr. Kronya Alex';...
                    'Dr. Lantos Bla';...
                    'Dr. Levendovszky Jnos';...
                    'Dr. Lovnyi Istvn';...
                    'Dr. Magos Andrs';...
                    'Dr. Majzik Istvn';...
                    'Dr. Mt Lszl';...
                    'Dr. Mizsei Jnos';...
                    'Dr. Nagy Dezs';...
                    'Dr. Nagy Lajos';...
                    'Dr. Orosz Gbor Tams';...
                    'Dr. Orosz Lszl';...
                    'Dr. Pacher Pl';...
                    'Dr. Pap Lszl';...
                    'Dr. Papp Zsolt';...
                    'Dr. Pataki Gergely';...
                    'Dr. Pataricza Andrs';...
                    'Dr. Pv Jzsef';...
                    'Dr. Pceli Gbor';...
                    'Dr. Pczeli Imre';...
                    'Dr. Prhle Pter';...
                    'dr. Ress Sndor Lszl';...
                    'Dr. Sallai Gyula';...
                    'Dr. Selnyi Endre';...
                    'Dr. Serny Gyrgy';...
                    'Dr. Simon Andrs';...
                    'Dr. Simon Vilmos';...
                    'Dr. Strausz Gyrgy';...
                    'Dr. Sujbert Lszl';...
                    'Dr. Szab Csaba Attila';...
                    'Dr. Szab Jzsef';...
                    'Dr. Szebernyi Imre';...
                    'Dr. Szp Gabriella';...
                    'Dr. Szeszlr Dvid';...
                    'Dr. Szirmay-Kalos Lszl';...
                    'Dr. Tasndi Tams';...
                    'Dr. Tevesz Gbor';...
                    'Dr. Tth Csaba';...
                    'Dr. Vajda Istvn';...
                    'Dr. Vajk Istvn';...
                    'Dr. Vajta Lszl';...
                    'Dr. Varga Gbor';...
                    'Dr. Varjasi Istvn';...
                    'Dr. Varr Dniel';...
                    'Dr. Vetier Andrs';...
                    'Dr. Vida Rolland';...
                    'Dr. Zombory Lszl';...
                    'Eged Bertalan Dr.';...
                    'Elek Klmn Dr.';...
                    'Erdei Jnos';...
                    'Eredics Pter';...
                    'Ers Levente';...
                    'Faludi Andor';...
                    'Farkas Barnabs';...
                    'Farkas Gbor Dr.';...
                    'Farkas Kroly';...
                    'Farkasvlgyi Andrea';...
                    'Fazekas Pter';...
                    'Fiala Pter';...
                    'Forstner Bertalan';...
                    'Friedl Katalin Dr.';...
                    'Fle Mikls Dr.';...
                    'Gal Jzsef Dr.';...
                    'Grtner Pter Dr.';...
                    'Gspr Csaba';...
                    'Gerhtn Udvary Eszter';...
                    'Gincsai Gbor';...
                    'Gschwindt Andrs Dr.';...
                    'Gulys Krisztin';...
                    'Gyimthy Szabolcs Dr.';...
                    'Gyre Attila';...
                    'Gyri Erzsbet';...
                    'Gyri Jen';...
                    'Harmati Istvn Dr.';...
                    'Helybly Zoltn Dr.';...
                    'Hornk Zoltn';...
                    'Horvth Barbara';...
                    'Horvth Eszter Edit';...
                    'Horvth Gbor';...
                    'Horvth Gyrgy';...
                    'Horvth Gyula';...
                    'Horvth Istvn Dr.';...
                    'Horvth Pter';...
                    'Horvth Tams Imre Dr.';...
                    'Horvth Zoltn';...
                    'Horvth Zoltn Gyrgy';...
                    'Hulmny Pter';...
                    'Huszk rpd';...
                    'Huszerl Gbor';...
                    'Ills Balzs Gyrgy';...
                    'Illyefalvi-Vitz Zsolt Dr.';...
                    'Imre Gbor';...
                    'Ivncsy Tams';...
                    'Jantek Balzs';...
                    'Juhsz Lszl';...
                    'Kdr Istvn Dr.';...
                    'Kalmr Pter Dr.';...
                    'Kanizsai Zoltn';...
                    'Kardkovcs Zsolt Tivadar';...
                    'Kasz Mrk';...
                    'Katona Lszl Dr.';...
                    'Kerecsen Istvnn Dr.';...
                    'Keszler Anita';...
                    'Ketskemty Lszl Dr.';...
                    'Kiss Domokos';...
                    'Kiss Imre';...
                    'Kiss Pter';...
                    'Kohri Zaln';...
                    'Koller Istvn Dr.';...
                    'Kondorosi Kroly Dr.';...
                    'Knya Ilona';...
                    'Kovcs Dniel Lszl';...
                    'Kovcs Ferenc';...
                    'Kovcs Gbor';...
                    'Kovcs Gyula dr.';...
                    'Kovcs Ilona Dr.';...
                    'Kovcs Imre Dr.';...
                    'Kovcshzy Tams';...
                    'Krammer Olivr';...
                    'Kulik Ivett';...
                    'Kunsgi Lszl';...
                    'Kuti Lszl';...
                    'Ladnyi Jzsef';...
                    'Lszl Zoltn Dr.';...
                    'Lnrt Ferenc Dr.';...
                    'Lengyel Lszl';...
                    'Lois Lszl Dr.';...
                    'Lukcs gnes dr.';...
                    'Magyar Gbor Dr.';...
                    'Mrki Ferenc';...
                    'Martinek Pter';...
                    'Max Gyula';...
                    'Mezei Gergely';...
                    'Micskei Zoltn Imre';...
                    'Mihly Zsigmond Dr.';...
                    'Mczr Gza Dr.';...
                    'Molnr Zoltn Gbor';...
                    'Nmeth Blint';...
                    'Nmeth Edit';...
                    'Nmeth Krisztin';...
                    'Nmeth Pl Dr.';...
                    'Neu Gergely';...
                    'Olh Istvn';...
                    'Orbn Gergely Gyula';...
                    'Patai Gergely';...
                    'Pzmndi Kinga dr.';...
                    'Petrczi Attila Istvn';...
                    'Petruska Ildik Dr.';...
                    'Pilszy Gyrgy';...
                    'Plh Csaba dr.';...
                    'Plesz Balzs';...
                    'Poppe Andrs Dr.';...
                    'Prikler Lszl';...
                    'Racsmny Mihly dr.';...
                    'Raisz Dvid Mrk';...
                    'Rajacsics Tams';...
                    'Reichardt Andrs Lszl';...
                    'Ruszink Mikls Dr.';...
                    'Schmidt Istvn Dr.';...
                    'Schulcz Rbert';...
                    'Seller Rudolf Dr.';...
                    'Simon Csaba';...
                    'Simon Gyula Dr.';...
                    'Simonyi Gbor Dr.';...
                    'Sinkovics Blint';...
                    'Siroki Lszl';...
                    'Sonkoly Balzs';...
                    'Stubnya Gusztvn Dr.';...
                    'Szab Lszl';...
                    'Szab Rbert Dr.';...
                    'Szab Sndor';...
                    'Szab Zoltn';...
                    'Szakadt Istvn dr.';...
                    'Szmel Lszl Dr.';...
                    'Sznt Pter';...
                    'Szatmri Zoltn';...
                    'Szcsi Lszl';...
                    'Szkely Ivn dr.';...
                    'Szkely Levente Dr.';...
                    'Szeredi Pter Dr.';...
                    'Szikora Bla Dr.';...
                    'Szombathy Csaba Zoltn';...
                    'Szrdin Dr Szab Mrta';...
                    'Szcs Gbor Dr.';...
                    'Szcs Zoltn';...
                    'Takcs Ildik Dr.';...
                    'Tarjn Balzs';...
                    'Temesvry Andrs';...
                    'Timrn Horvth Veronika';...
                    'Titkos Tams';...
                    'Tth Lszl Dr.';...
                    'Trk Attila';...
                    'Vajda Ferenc Dr.';...
                    'Vajda Lrnt';...
                    'Varga Dniel';...
                    'Varga Gyrgy';...
                    'Varga Pl';...
                    'Varj Gyrgy Dr.';...
                    'Varr Gergely Gyrgy';...
                    'Verebics Jnos Dr.';...
                    'Veress Jzsef dr.';...
                    'Veszely Gyula Dr.';...
                    'Veszprmi Kroly Dr.';...
                    'Vigh Lszl dr.';...
                    'Vincze Gyuln Dr.';...
                    'Vitz Andrs';...
                    'Wiener Gbor Dr.';...
                    'Zempln Gbor';...
                    'Zombori Zsolt';...
                    'Zska Zoltn'};

    % vfolyam(vfolyam megnevezse)
    fp.class =     {'1. vfolyam - Villamosmrnk szak';...
                    '1. vfolyam - Villamosmrnk szak keresztflv';...
                    '1. vfolyam - Mrnk-informatikus szak';...
                    '1. vfolyam - Mrnk-informatikus szak keresztflv';...
                    '2. vfolyam - Villamosmrnk szak';...
                    '2. vfolyam - Villamosmrnk szak keresztflv';...
                    '2. vfolyam - Mrnk-informatikus szak';...
                    '2. vfolyam - Mrnk-informatikus szak keresztflv';...
                    '3. vfolyam - Villamosmrnk szak';...
                    '3. vfolyam - Villamosmrnk szak keresztflv';...
                    '3. vfolyam - Mrnk-informatikus szak';...
                    '3. vfolyam - Mrnk-informatikus szak keresztflv';...
                    '4. vfolyam - Mrnk-informatikus szak keresztflv';...
                    'Vlaszthat'};

    % Tanszk(Tanszk rvidtett neve, Tanszk teljes neve)
    fp.department ={'AUT', 'Automatizlsi s Alkalmazott Informatikai Tanszk';...
                    'ETT', 'Elektronikai Technolgia Tanszk';...
                    'EET', 'Elektronikus Eszkzk Tanszk';...
                    'HIT', 'Hradstechnikai Tanszk';...
                    'IIT', 'Irnytstechnika s Informatika Tanszk';...
                    'MIT', 'Mrstechnika s Informcis Rendszerek Tanszk';...
                    'SZIT', 'Szmtstudomnyi s Informcielmleti Tanszk';...
                    'HVT', 'Szlessv Hrkzls s Villamossgtan Tanszk';...
                    'TMIT', 'Tvkzlsi s Mdiainformatikai Tanszk';...
                    'VET', 'Villamos Energetika Tanszk'};
 
    % plet(plet neve)
    fp.building =  {'CH';...
                    'E';...
                    'F';...
                    'H';...
                    'I';...
                    'K';...
                    'R';...
                    'ST';...
                    'T';...
                    'V1';...
                    'V2';...
                    'Z'};

    % pletek kzti tlagos gyalogt ideje [perc]
    fp.buildingtd =[0, 15, 5, 10, 20, 10, 10, 10, 10, 15, 15, 10;...
                    15, 0, 10, 5, 10, 10, 5, 5, 5, 5, 5, 10;...
                    5, 10, 0, 10, 15, 5, 10, 5, 10, 10, 10, 10;...
                    10, 5, 10, 0, 10, 10, 5, 10, 5, 10, 10, 10;...
                    20, 10, 15, 10, 0, 15, 15, 20, 15, 15, 15, 20;...
                    10, 10, 5, 10, 15, 0, 10, 10, 10, 10, 10, 10;...
                    10, 5, 10, 5, 15, 10, 0, 10, 5, 10, 10, 10;...
                    10, 5, 5, 10, 20, 10, 10, 0, 10, 10, 10, 10;...
                    10, 5, 10, 5, 15, 10, 5, 10, 0, 10, 10, 10;...
                    15, 5, 10, 10, 15, 10, 10, 10, 10, 0, 10, 10;...
                    15, 5, 10, 10, 15, 10, 10, 10, 10, 10, 0, 10;...
                    10, 10, 10, 10, 20, 10, 10, 10, 10, 10, 10, 0];

    % Nap(Nap megnevezse)
    fp.day =       {'Htf';...
                    'Kedd';...
                    'Szerda';...
                    'Cstrtk';...
                    'Pntek'};
               
	% Now lets switch according to the problem-specific parts...
    switch probnum

        case 1
              
            % Kurzus(Trgy ID, Kurzuskd, Kurzustpus ID, Oktatk ID, vfolyam ID, Hossz (ra), Alkalmak szma, Jelentkezsi limit)
            fp.course =    {1, 'SZV-E', 1, [46 87], 14, 4, 1, 50;...
                            4, 'E', 1, [284], 2, 2, 1, 300;...
                            4, 'G0', 2, [284], 2, 1, 1, 30;...
                            4, 'G1', 2, [284], 2, 1, 1, 30;...
                            31, '1', 1, [242], 3, 2, 1, 500};

            % Terem(Terem neve, plet ID, Frhelyek szma, Alkalmas labornak?, Tanszk ID)
            fp.classroom = {'E602', 2, 50, 0, 0;...
                            'IB028', 5, 500, 0, 0};

            % Kezdsi idpontok(Nap ID, Kezds rja)
            % Megj.: kezds mindig negyedkor, befejezs egszkor
            fp.starttime = [1, 8;...
                            1, 9;...
                            1, 10];
        
        case 2
              
            % Kurzus(Trgy ID, Kurzuskd, Kurzustpus ID, Oktatk ID, vfolyam ID, Hossz (ra), Alkalmak szma, Jelentkezsi limit)
            fp.course =    {1, 'SZV-E', 1, [46 87], 14, 4, 1, 50;...
                            2, '1', 1, [174], 14, 2, 2, 50;...
                            3, 'T0', 1, [53], 14, 2, 1, 50;...
                            4, 'E', 1, [284], 2, 2, 1, 300;...
                            4, 'G0', 2, [284], 2, 1, 1, 30;...
                            4, 'G1', 2, [284], 2, 1, 1, 30;...
                            31, '1', 1, [242], 3, 2, 1, 500};

            % Terem(Terem neve, plet ID, Frhelyek szma, Alkalmas labornak?, Tanszk ID)
            fp.classroom = {'E1B', 2, 500, 0, 0;...
                            'E602', 2, 50, 0, 0;...
                            'IB028', 5, 500, 0, 0;...
                            'IB140', 5, 30, 0, 0};

            % Kezdsi idpontok(Nap ID, Kezds rja)
            % Megj.: kezds mindig negyedkor, befejezs egszkor
            fp.starttime = [1, 8;...
                            1, 9;...
                            1, 10;...
                            1, 11;...
                            1, 12];

        otherwise
          
            % Kurzus(Trgy ID, Kurzuskd, Kurzustpus ID, Oktatk ID, vfolyam ID, Hossz (ra), Alkalmak szma hetente, Jelentkezsi limit)
            fp.course =    {1, 'SZV-E', 1, [46 87], 14, 4, 1, 50;...
                            2, '1', 1, [174], 14, 2, 2, 50;...
                            3, 'T0', 1, [53], 14, 2, 1, 50;...
                            4, 'E', 1, [284], 2, 2, 1, 300;...
                            4, 'G0', 2, [284], 2, 1, 1, 30;...
                            4, 'G1', 2, [284], 2, 1, 1, 30;...
                            4, 'G2', 2, [284], 2, 1, 1, 30;...
                            4, 'G3', 2, [284], 2, 1, 1, 30;...
                            4, 'G4', 2, [284], 2, 1, 1, 30;...
                            4, 'G5', 2, [284], 2, 1, 1, 30;...
                            4, 'GA', 2, [284], 2, 1, 1, 30;...
                            4, 'GB', 2, [284], 2, 1, 1, 30;...
                            4, 'GC', 2, [284], 2, 1, 1, 30;...
                            4, 'GD', 2, [284], 2, 1, 1, 30;...
                            4, 'GE', 2, [284], 2, 1, 1, 30;...
                            4, 'GF', 2, [284], 2, 1, 1, 30;...
                            4, 'L0', 3, [284], 2, 1, 1, 30;...
                            4, 'L1', 3, [284], 2, 1, 1, 30;...
                            4, 'L2', 3, [284], 2, 1, 1, 30;...
                            4, 'L3', 3, [284], 2, 1, 1, 30;...
                            4, 'L4', 3, [284], 2, 1, 1, 30;...
                            4, 'L5', 3, [284], 2, 1, 1, 30;...
                            4, 'LA', 3, [284], 2, 1, 1, 30;...
                            4, 'LB', 3, [284], 2, 1, 1, 30;...
                            4, 'LC', 3, [284], 2, 1, 1, 30;...
                            4, 'LD', 3, [284], 2, 1, 1, 30;...
                            4, 'LE', 3, [284], 2, 1, 1, 30;...
                            4, 'LF', 3, [284], 2, 1, 1, 30;...
                            5, 'ME3', 1, [138], 1, 2, 1, 500;...
                            5, 'MGY1', 3, [204], 1, 2, 1, 30;...
                            5, 'MGY2', 3, [204], 1, 2, 1, 30;...
                            5, 'MGY3', 3, [204], 1, 2, 1, 30;...
                            183, 'BSCE', 1, [110], 3, 2, 1, 500;...
                            183, 'Tank1', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank10', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank11', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank12', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank13', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank14', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank15', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank16', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank17', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank18', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank2', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank3', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank4', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank5', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank6', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank7', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank8', 2, [110], 3, 2, 1, 30;...
                            183, 'Tank9', 2, [110], 3, 2, 1, 30;...
                            6, 'HV', 1, [88], 14, 2, 2, 50;...
                            7, 'SZV-E', 1, [110], 14, 2, 2, 50;...
                            8, '1', 3, [19], 11, 4, 1, 30;...
                            9, '1', 1, [61 143], 14, 2, 1, 50;...
                            10, '1', 1, [68 69], 14, 2, 1, 50;...
                            10, '2', 2, [68], 14, 2, 1, 50;...
                            11, 'E', 1, [81], 11, 2, 1, 500;...
                            11, 'G', 2, [81], 11, 2, 1, 30;...
                            12, '2', 1, [256], 9, 2, 2, 500;...
                            13, '3', 1, [68 191], 11, 2, 2, 500;...
                            13, 'G4', 2, [68 191], 11, 2, 1, 30;...
                            13, 'G5', 2, [68 191], 11, 2, 1, 30;...
                            14, '1', 1, [139], 7, 2, 1, 500;...
                            14, '11', 2, [], 7, 2, 1, 30;...
                            14, '12', 2, [], 7, 2, 1, 30;...
                            14, '13', 2, [], 7, 2, 1, 30;...
                            14, '14', 2, [], 7, 2, 1, 30;...
                            14, '15', 2, [], 7, 2, 1, 30;...
                            14, '16', 2, [], 7, 2, 1, 30;...
                            14, '17', 2, [], 7, 2, 1, 30;...
                            14, '18', 2, [], 7, 2, 1, 30;...
                            14, '19', 2, [], 7, 2, 1, 30;...
                            14, '20', 2, [], 7, 2, 1, 30;...
                            14, '21', 2, [], 7, 2, 1, 30;...
                            14, '22', 2, [], 7, 2, 1, 30;...
                            14, '23', 2, [], 7, 2, 1, 30;...
                            14, '24', 2, [], 7, 2, 1, 30;...
                            14, '25', 2, [], 7, 2, 1, 30;...
                            14, '26', 2, [], 7, 2, 1, 30;...
                            14, '27', 2, [], 7, 2, 1, 30;...
                            14, '28', 2, [], 7, 2, 1, 30;...
                            14, '29', 2, [], 7, 2, 1, 30;...
                            15, '5', 1, [233], 14, 2, 1, 50;...
                            16, 'EA', 1, [189], 4, 2, 2, 300;...
                            16, 'G1', 2, [], 4, 2, 1, 30;...
                            16, 'G2', 2, [], 4, 2, 1, 30;...
                            16, 'G3', 2, [], 4, 2, 1, 30;...
                            17, 'A0', 1, [114], 3, 2, 2, 500;...
                            17, 'A1', 2, [], 3, 2, 1, 30;...
                            17, 'A2', 2, [], 3, 2, 1, 30;...
                            17, 'A3', 2, [], 3, 2, 1, 30;...
                            17, 'A4', 2, [], 3, 2, 1, 30;...
                            17, 'A5', 2, [], 3, 2, 1, 30;...
                            17, 'A6', 2, [], 3, 2, 1, 30;...
                            17, 'B0', 1, [189], 3, 2, 2, 500;...
                            17, 'B1', 2, [], 3, 2, 1, 30;...
                            17, 'B2', 2, [], 3, 2, 1, 30;...
                            17, 'B3', 2, [], 3, 2, 1, 30;...
                            17, 'B4', 2, [], 3, 2, 1, 30;...
                            17, 'B5', 2, [], 3, 2, 1, 30;...
                            17, 'B6', 2, [], 3, 2, 1, 30;...
                            17, 'C0', 1, [94], 3, 2, 2, 500;...
                            17, 'C1', 2, [], 3, 2, 1, 30;...
                            17, 'C2', 2, [], 3, 2, 1, 30;...
                            17, 'C3', 2, [], 3, 2, 1, 30;...
                            17, 'C4', 2, [], 3, 2, 1, 30;...
                            17, 'C5', 2, [], 3, 2, 1, 30;...
                            17, 'C6', 2, [], 3, 2, 1, 30;...
                            18, 'KF', 1, [30], 2, 2, 2, 300;...
                            18, 'Lab', 3, [], 2, 2, 1, 30;...
                            19, 'SZE', 1, [74 80 152], 11, 2, 1, 500;...
                            19, 'SZGY', 2, [74 80 152], 11, 2, 1, 30;...
                            20, 'SZL', 3, [74], 11, 4, 1, 30;...
                            21, '1', 1, [186 283], 14, 2, 2, 50;...
                            22, '1', 1, [77 256], 14, 2, 1, 50;...
                            22, '2', 2, [77 256], 14, 2, 1, 50;...
                            23, '12', 1, [232], 14, 2, 1, 50;...
                            24, 'HV', 1, [41 144], 14, 2, 1, 50;...
                            24, 'HV_1', 2, [41 144], 14, 2, 1, 50;...
                            25, '1', 1, [47], 9, 2, 1, 500;...
                            25, '2', 2, [47], 9, 2, 1, 30;...
                            26, '1', 3, [51 253], 9, 4, 1, 30;...
                            26, '2', 3, [51 253], 9, 4, 1, 30;...
                            27, 'SZV', 1, [58 223], 14, 2, 1, 50;...
                            28, '1', 1, [97], 11, 2, 1, 500;...
                            28, '2', 2, [97], 11, 2, 1, 30;...
                            29, '4', 1, [138], 14, 2, 1, 50;...
                            30, '1', 1, [112], 4, 2, 1, 300;...
                            30, '11', 2, [], 4, 2, 1, 30;...
                            30, '12', 2, [], 4, 2, 1, 30;...
                            30, '13', 2, [], 4, 2, 1, 30;...
                            30, '14', 2, [], 4, 2, 1, 30;...
                            30, '15', 2, [], 4, 2, 1, 30;...
                            30, '16', 2, [], 4, 2, 1, 30;...
                            30, '17', 2, [], 4, 2, 1, 30;...
                            31, '1', 1, [242], 3, 2, 1, 500;...
                            31, '2', 1, [285], 3, 2, 1, 500;...
                            31, '10', 2, [], 3, 2, 1, 30;...
                            31, '11', 2, [], 3, 2, 1, 30;...
                            31, '12', 2, [], 3, 2, 1, 30;...
                            31, '13', 2, [], 3, 2, 1, 30;...
                            31, '14', 2, [], 3, 2, 1, 30;...
                            31, '15', 2, [], 3, 2, 1, 30;...
                            31, '16', 2, [], 3, 2, 1, 30;...
                            31, '17', 2, [], 3, 2, 1, 30;...
                            31, '18', 2, [], 3, 2, 1, 30;...
                            31, '19', 2, [], 3, 2, 1, 30;...
                            31, '20', 2, [], 3, 2, 1, 30;...
                            31, '21', 2, [], 3, 2, 1, 30;...
                            31, '22', 2, [], 3, 2, 1, 30;...
                            31, '23', 2, [], 3, 2, 1, 30;...
                            31, '24', 2, [], 3, 2, 1, 30;...
                            31, '25', 2, [], 3, 2, 1, 30;...
                            31, '26', 2, [], 3, 2, 1, 30;...
                            31, '27', 2, [], 3, 2, 1, 30;...
                            32, 'T0', 1, [38], 14, 2, 1, 50;...
                            33, '1', 1, [154], 14, 2, 2, 50;...
                            34, '4', 1, [17 216], 14, 2, 1, 50;...
                            35, '1', 1, [204 221], 14, 4, 1, 50;...
                            36, '1', 1, [58 258], 13, 2, 1, 300;...
                            36, '1a', 2, [58 258], 13, 2, 1, 30;...
                            37, 'KE', 1, [36 160], 2, 2, 2, 300;...
                            37, 'KG1', 2, [162], 2, 2, 1, 30;...
                            37, 'KG2', 2, [162], 2, 2, 1, 30;...
                            37, 'KG3', 2, [162], 2, 2, 1, 30;...
                            37, 'KG4', 2, [162], 2, 2, 1, 30;...
                            38, '1', 1, [40], 4, 2, 1, 300;...
                            38, '2', 2, [40], 4, 2, 1, 30;...
                            39, 'BSCE', 1, [160 162 175], 1, 2, 1, 500;...
                            39, 'Tank1', 2, [271], 1, 2, 1, 30;...
                            39, 'Tank10', 2, [162], 1, 2, 1, 30;...
                            39, 'Tank11', 2, [160], 1, 2, 1, 30;...
                            39, 'Tank12', 2, [214], 1, 2, 1, 30;...
                            39, 'Tank13', 2, [160], 1, 2, 1, 30;...
                            39, 'Tank14', 2, [214], 1, 2, 1, 30;...
                            39, 'Tank15', 2, [160], 1, 2, 1, 30;...
                            39, 'Tank16', 2, [175], 1, 2, 1, 30;...
                            39, 'Tank2', 2, [227], 1, 2, 1, 30;...
                            39, 'Tank3', 2, [271], 1, 2, 1, 30;...
                            39, 'Tank4', 2, [227], 1, 2, 1, 30;...
                            39, 'Tank5', 2, [271], 1, 2, 1, 30;...
                            39, 'Tank6', 2, [214], 1, 2, 1, 30;...
                            39, 'Tank7', 2, [227], 1, 2, 1, 30;...
                            39, 'Tank8', 2, [162], 1, 2, 1, 30;...
                            39, 'Tank9', 2, [227], 1, 2, 1, 30;...
                            40, '1', 1, [51 102], 3, 2, 2, 500;...
                            40, '2', 2, [51 102], 3, 2, 1, 30;...
                            40, '3', 2, [51 102], 3, 2, 1, 30;...
                            40, '4', 2, [51 102], 3, 2, 1, 30;...
                            40, '5', 2, [51 102], 3, 2, 1, 30;...
                            40, '6', 2, [51 102], 3, 2, 1, 30;...
                            40, '7', 2, [51 102], 3, 2, 1, 30;...
                            40, '8', 2, [51 102], 3, 2, 1, 30;...
                            40, '9', 2, [51 102], 3, 2, 1, 30;...
                            40, '10', 2, [51 102], 3, 2, 1, 30;...
                            40, '11', 2, [51 102], 3, 2, 1, 30;...
                            40, '12', 2, [51 102], 3, 2, 1, 30;...
                            40, '13', 2, [51 102], 3, 2, 1, 30;...
                            40, '14', 2, [51 102], 3, 2, 1, 30;...
                            40, '15', 2, [51 102], 3, 2, 1, 30;...
                            40, '16', 2, [51 102], 3, 2, 1, 30;...
                            40, '17', 2, [51 102], 3, 2, 1, 30;...
                            40, '18', 2, [51 102], 3, 2, 1, 30;...
                            40, '19', 2, [51 102], 3, 2, 1, 30;...
                            41, 'L1', 3, [70], 14, 2, 1, 50;...
                            41, 'L2', 3, [147], 14, 2, 1, 50;...
                            41, 'OO', 3, [176], 14, 2, 1, 50;...
                            41, 'W2', 3, [238], 14, 2, 1, 50;...
                            42, '1', 1, [262], 14, 2, 1, 50;...
                            43, '1', 1, [122], 14, 2, 1, 50;...
                            43, '2', 3, [122], 14, 2, 1, 50;...
                            44, '2', 1, [280], 5, 2, 2, 500;...
                            44, 'BA', 2, [96], 5, 2, 1, 30;...
                            44, 'BB', 2, [], 5, 2, 1, 30;...
                            44, 'BC', 2, [], 5, 2, 1, 30;...
                            44, 'BD', 2, [148], 5, 2, 1, 30;...
                            44, 'BE', 2, [184], 5, 2, 1, 30;...
                            44, 'BF', 2, [125], 5, 2, 1, 30;...
                            44, 'BG', 2, [148], 5, 2, 1, 30;...
                            44, 'BH', 2, [15], 5, 2, 1, 30;...
                            44, 'BI', 2, [96], 5, 2, 1, 30;...
                            44, 'BJ', 2, [18], 5, 2, 1, 30;...
                            44, 'BK', 2, [9], 5, 2, 1, 30;...
                            44, 'BL', 2, [184], 5, 2, 1, 30;...
                            44, 'BM', 2, [96], 5, 2, 1, 30;...
                            44, 'BN', 2, [148], 5, 2, 1, 30;...
                            44, 'BO', 2, [125], 5, 2, 1, 30;...
                            44, 'BP', 2, [18], 5, 2, 1, 30;...
                            44, 'BQ', 2, [], 5, 2, 1, 30;...
                            44, 'BR', 2, [235], 5, 2, 1, 30;...
                            45, 'E', 1, [92 213], 5, 3, 1, 500;...
                            45, 'G', 2, [213], 5, 2, 1, 30;...
                            45, 'G1', 2, [241], 5, 2, 1, 30;...
                            45, 'G10', 2, [127], 5, 2, 1, 30;...
                            45, 'G11', 2, [241], 5, 2, 1, 30;...
                            45, 'G12', 2, [241], 5, 2, 1, 30;...
                            45, 'G13', 2, [141], 5, 2, 1, 30;...
                            45, 'G14', 2, [257], 5, 2, 1, 30;...
                            45, 'G2', 2, [213], 5, 2, 1, 30;...
                            45, 'G3', 2, [127], 5, 2, 1, 30;...
                            45, 'G4', 2, [92], 5, 2, 1, 30;...
                            45, 'G5', 2, [187], 5, 2, 1, 30;...
                            45, 'G6', 2, [141], 5, 2, 1, 30;...
                            45, 'G7', 2, [213], 5, 2, 1, 30;...
                            45, 'G8', 2, [127], 5, 2, 1, 30;...
                            45, 'G9', 2, [257], 5, 2, 1, 30;...
                            46, '5', 1, [4 62 73 121], 10, 3, 1, 300;...
                            46, 'Gy11', 2, [4 62 73 121], 10, 2, 1, 30;...
                            46, 'Gy12', 2, [4 62 73 121], 10, 2, 1, 30;...
                            46, 'Gy13', 2, [4 62 73 121], 10, 2, 1, 30;...
                            46, 'Gy14', 2, [4 62 73 121], 10, 2, 1, 30;...
                            46, 'Gy15', 2, [4 62 73 121], 10, 2, 1, 30;...
                            46, 'Gy16', 2, [4 62 73 121], 10, 2, 1, 30;...
                            47, '3', 1, [169 197 219], 9, 2, 1, 500;...
                            47, '3_Gy', 2, [169 197], 9, 2, 1, 30;...
                            48, 'HV', 2, [126 260], 14, 2, 1, 50;...
                            49, '1', 1, [71], 14, 2, 2, 50;...
                            50, '22', 1, [217], 9, 2, 2, 500;...
                            51, 'SZV-E', 1, [82 89], 14, 2, 1, 50;...
                            51, 'SZV-Gy', 2, [82 89], 14, 2, 1, 50;...
                            52, '11', 1, [193], 14, 2, 1, 50;...
                            53, 'V1', 1, [38 98], 1, 2, 2, 500;...
                            53, 'V2', 1, [90], 1, 2, 2, 500;...
                            53, 'VA', 1, [31 59], 1, 2, 1, 500;...
                            53, 'VAgy', 2, [31 59], 1, 2, 1, 30;...
                            53, 'Vigy1', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy10', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy11', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy12', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy13', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy14', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy15', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy2', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy3', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy4', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy5', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy6', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy7', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy8', 2, [], 1, 2, 1, 30;...
                            53, 'Vigy9', 2, [], 1, 2, 1, 30;...
                            54, 'I1', 1, [57], 3, 2, 2, 500;...
                            54, 'I2', 1, [91], 3, 2, 2, 500;...
                            54, 'IA', 1, [43], 3, 2, 2, 500;...
                            54, 'IAgy', 2, [43], 3, 2, 1, 30;...
                            54, 'Infgy1', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy10', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy11', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy12', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy13', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy14', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy15', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy16', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy17', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy18', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy2', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy3', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy4', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy5', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy6', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy7', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy8', 2, [], 3, 2, 1, 30;...
                            54, 'Infgy9', 2, [], 3, 2, 1, 30;...
                            55, 'Vigy1', 2, [], 6, 2, 1, 30;...
                            55, 'Vigy2', 2, [], 6, 2, 1, 30;...
                            55, 'Vigy3', 2, [], 6, 2, 1, 30;...
                            55, 'Vigy4', 2, [], 6, 2, 1, 30;...
                            55, 'VX', 1, [93], 6, 2, 2, 300;...
                            56, 'Infgy1', 2, [], 8, 2, 1, 30;...
                            56, 'Infgy2', 2, [], 8, 2, 1, 30;...
                            56, 'Infgy3', 2, [], 8, 2, 1, 30;...
                            56, 'Infgy4', 2, [], 8, 2, 1, 30;...
                            56, 'Infgy5', 2, [], 8, 2, 1, 30;...
                            56, 'Infgy6', 2, [], 8, 2, 1, 30;...
                            56, 'Infgy7', 2, [], 8, 2, 1, 30;...
                            56, 'Infgy8', 2, [], 8, 2, 1, 30;...
                            56, 'IX', 1, [120], 8, 2, 2, 300;...
                            57, 'T0', 1, [85], 14, 2, 2, 50;...
                            58, '1', 1, [76], 14, 2, 2, 50;...
                            59, '4', 1, [77 101], 11, 2, 1, 500;...
                            59, '5', 2, [77 101], 11, 2, 1, 30;...
                            60, 'A7', 1, [32 279], 9, 2, 2, 500;...
                            61, '1', 1, [211], 14, 4, 1, 50;...
                            62, 'SZV-E', 1, [255], 14, 2, 2, 50;...
                            63, '7', 1, [34 124], 9, 2, 1, 500;...
                            63, '8', 2, [34 124], 9, 2, 1, 30;...
                            64, 'E', 1, [137], 14, 2, 2, 50;...
                            65, 'E', 1, [208], 14, 2, 1, 50;...
                            65, 'G', 2, [208], 14, 2, 1, 50;...
                            66, '1', 1, [56 270 272], 14, 2, 1, 50;...
                            67, '3', 3, [158], 9, 4, 1, 30;...
                            68, '2', 3, [63 198 245], 11, 4, 2, 30;...
                            69, 'E', 1, [288], 11, 2, 1, 500;...
                            69, 'G', 2, [288], 11, 2, 1, 30;...
                            70, '10', 1, [34 207 275], 11, 2, 2, 500;...
                            70, '11', 3, [34 207 275], 11, 4, 1, 30;...
                            70, '12', 3, [34 207 275], 11, 4, 1, 30;...
                            71, '1', 1, [97], 14, 2, 1, 50;...
                            72, 'KE', 1, [188 214], 6, 2, 2, 300;...
                            72, 'KG', 2, [188 214], 6, 2, 1, 30;...
                            73, 'EA2', 1, [69 118], 5, 2, 2, 500;...
                            73, 'Gy01', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy02', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy03', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy04', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy05', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy06', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy07', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy08', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy09', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy10', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy11', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy12', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy13', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy14', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy15', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy16', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy17', 2, [69 118], 5, 2, 1, 30;...
                            73, 'Gy18', 2, [69 118], 5, 2, 1, 30;...
                            74, '1', 2, [33 199], 14, 4, 1, 50;...
                            75, '3', 3, [44 95 188], 11, 4, 1, 30;...
                            182, 'SZL', 3, [202], 11, 4, 1, 30;...
                            181, '1', 3, [84], 11, 4, 1, 30;...
                            76, '1', 3, [106 190], 11, 4, 1, 30;...
                            77, '1', 1, [167 212], 11, 2, 1, 500;...
                            77, '2', 2, [167 212], 11, 2, 1, 30;...
                            78, '4', 1, [248], 11, 2, 1, 500;...
                            78, '5', 2, [248], 11, 2, 1, 30;...
                            79, 'SZE', 1, [82 119], 11, 2, 1, 500;...
                            79, 'SZG', 2, [82 119], 11, 2, 1, 30;...
                            80, '1', 1, [211 234], 14, 2, 1, 50;...
                            80, '2', 2, [211 234], 14, 2, 1, 50;...
                            81, 'E', 1, [14], 14, 2, 2, 50;...
                            82, 'A1', 1, [96], 7, 2, 2, 500;...
                            82, 'BA', 2, [88], 7, 2, 1, 30;...
                            82, 'BB', 2, [161], 7, 2, 1, 30;...
                            82, 'BC', 2, [88], 7, 2, 1, 30;...
                            82, 'BD', 2, [88], 7, 2, 1, 30;...
                            82, 'BE', 2, [144], 7, 2, 1, 30;...
                            82, 'BF', 2, [88], 7, 2, 1, 30;...
                            82, 'BG', 2, [29], 7, 2, 1, 30;...
                            82, 'BH', 2, [135], 7, 2, 1, 30;...
                            82, 'BI', 2, [88], 7, 2, 1, 30;...
                            82, 'BJ', 2, [163 164], 7, 2, 1, 30;...
                            82, 'BK', 2, [9], 7, 2, 1, 30;...
                            82, 'BL', 2, [2], 7, 2, 1, 30;...
                            82, 'BM', 2, [135], 7, 2, 1, 30;...
                            82, 'BN', 2, [126], 7, 2, 1, 30;...
                            82, 'BO', 2, [163 164], 7, 2, 1, 30;...
                            82, 'BP', 2, [88], 7, 2, 1, 30;...
                            82, 'BQ', 2, [88], 7, 2, 1, 30;...
                            82, 'BR', 2, [88], 7, 2, 1, 30;...
                            83, 'A1', 1, [9], 1, 2, 2, 500;...
                            83, 'BA', 2, [163 164], 1, 2, 1, 30;...
                            83, 'BB', 2, [18], 1, 2, 1, 30;...
                            83, 'BC', 2, [165], 1, 2, 1, 30;...
                            83, 'BD', 2, [184], 1, 2, 1, 30;...
                            83, 'BE', 2, [144], 1, 2, 1, 30;...
                            83, 'BF', 2, [83], 1, 2, 1, 30;...
                            83, 'BG', 2, [2], 1, 2, 1, 30;...
                            83, 'BH', 2, [235], 1, 2, 1, 30;...
                            83, 'BI', 2, [18], 1, 2, 1, 30;...
                            83, 'BJ', 2, [135], 1, 2, 1, 30;...
                            83, 'BK', 2, [235], 1, 2, 1, 30;...
                            83, 'BL', 2, [21], 1, 2, 1, 30;...
                            83, 'BM', 2, [163 164], 1, 2, 1, 30;...
                            83, 'BN', 2, [15], 1, 2, 1, 30;...
                            83, 'BO', 2, [9], 1, 2, 1, 30;...
                            84, 'A1', 1, [148], 6, 2, 2, 300;...
                            84, 'B1', 2, [163 164], 6, 2, 1, 30;...
                            84, 'B2', 2, [83], 6, 2, 1, 30;...
                            84, 'B3', 2, [161], 6, 2, 1, 30;...
                            84, 'B4', 2, [29], 6, 2, 1, 30;...
                            84, 'B5', 2, [235], 6, 2, 1, 30;...
                            85, '1', 1, [100 159], 14, 2, 1, 50;...
                            85, '2', 3, [100], 14, 2, 1, 50;...
                            86, '1', 1, [49 65 157], 11, 2, 1, 500;...
                            86, '2', 2, [49 65 157], 11, 2, 1, 30;...
                            87, '1', 1, [44 221], 14, 4, 1, 50;...
                            88, '12', 1, [140], 9, 2, 2, 500;...
                            89, '1', 1, [286], 9, 2, 2, 500;...
                            90, 'H11', 3, [27], 9, 3, 1, 30;...
                            90, 'H12', 3, [27], 9, 3, 1, 30;...
                            90, 'H13', 3, [27], 9, 3, 1, 30;...
                            90, 'H14', 3, [27], 9, 3, 1, 30;...
                            90, 'H15', 3, [27], 9, 3, 1, 30;...
                            90, 'H21', 3, [27], 9, 3, 1, 30;...
                            90, 'H22', 3, [27], 9, 3, 1, 30;...
                            90, 'H23', 3, [27], 9, 3, 1, 30;...
                            90, 'H24', 3, [27], 9, 3, 1, 30;...
                            90, 'H25', 3, [27], 9, 3, 1, 30;...
                            90, 'K11', 3, [27], 9, 3, 1, 30;...
                            90, 'K12', 3, [27], 9, 3, 1, 30;...
                            90, 'K13', 3, [27], 9, 3, 1, 30;...
                            90, 'K14', 3, [27], 9, 3, 1, 30;...
                            90, 'K15', 3, [27], 9, 3, 1, 30;...
                            90, 'S11', 3, [27], 9, 3, 1, 30;...
                            90, 'S12', 3, [27], 9, 3, 1, 30;...
                            90, 'S13', 3, [27], 9, 3, 1, 30;...
                            90, 'S14', 3, [27], 9, 3, 1, 30;...
                            90, 'S15', 3, [27], 9, 3, 1, 30;...
                            91, '12', 1, [193 194 206 228 232], 9, 2, 2, 500;...
                            92, '4', 1, [252 283], 14, 2, 1, 50;...
                            93, '1', 1, [8 204], 14, 4, 1, 50;...
                            93, '2', 2, [8 204], 14, 4, 1, 50;...
                            94, 'A1', 1, [226], 9, 2, 2, 500;...
                            95, 'V0', 1, [104], 2, 2, 2, 300;...
                            95, 'V1', 2, [246], 2, 2, 1, 30;...
                            95, 'V2', 2, [215], 2, 2, 1, 30;...
                            95, 'V3', 2, [132], 2, 2, 1, 30;...
                            95, 'V4', 2, [], 2, 2, 1, 30;...
                            95, 'V5', 2, [], 2, 2, 1, 30;...
                            96, 'U0', 1, [78], 1, 2, 2, 500;...
                            96, 'U1', 2, [], 1, 2, 1, 30;...
                            96, 'U2', 2, [], 1, 2, 1, 30;...
                            96, 'U3', 2, [], 1, 2, 1, 30;...
                            96, 'U4', 2, [], 1, 2, 1, 30;...
                            96, 'U5', 2, [], 1, 2, 1, 30;...
                            96, 'V0', 1, [35], 1, 2, 2, 500;...
                            96, 'V1', 2, [], 1, 2, 1, 30;...
                            96, 'V2', 2, [], 1, 2, 1, 30;...
                            96, 'V3', 2, [], 1, 2, 1, 30;...
                            96, 'V4', 2, [], 1, 2, 1, 30;...
                            96, 'V5', 2, [], 1, 2, 1, 30;...
                            96, 'W0', 1, [103], 1, 2, 2, 500;...
                            96, 'W1', 2, [132], 1, 2, 1, 30;...
                            96, 'W2', 2, [79], 1, 2, 1, 30;...
                            96, 'W3', 2, [246], 1, 2, 1, 30;...
                            96, 'W4', 2, [215], 1, 2, 1, 30;...
                            96, 'W5', 2, [172], 1, 2, 1, 30;...
                            96, 'W6', 2, [], 1, 2, 1, 30;...
                            97, 'V0', 1, [66], 6, 2, 1, 300;...
                            97, 'V1', 2, [], 6, 2, 1, 30;...
                            97, 'V2', 2, [], 6, 2, 1, 30;...
                            97, 'V3', 2, [], 6, 2, 1, 30;...
                            97, 'V4', 2, [], 6, 2, 1, 30;...
                            98, 'U0', 1, [123], 6, 2, 1, 300;...
                            98, 'U1', 2, [123], 6, 2, 1, 30;...
                            98, 'U2', 2, [123], 6, 2, 1, 30;...
                            98, 'U3', 2, [123], 6, 2, 1, 30;...
                            98, 'U4', 2, [123], 6, 2, 1, 30;...
                            98, 'W0', 1, [53], 6, 2, 1, 300;...
                            98, 'W1', 2, [53], 6, 2, 1, 30;...
                            98, 'W2', 2, [53], 6, 2, 1, 30;...
                            98, 'W3', 2, [111], 6, 2, 1, 30;...
                            98, 'W4', 2, [99], 6, 2, 1, 30;...
                            99, '5', 1, [52], 11, 2, 1, 500;...
                            99, '6', 2, [52], 11, 2, 1, 30;...
                            100, '2', 3, [63 198 245], 11, 4, 2, 30;...
                            101, 'E', 1, [195], 9, 2, 1, 500;...
                            101, 'G', 2, [195], 9, 2, 1, 30;...
                            102, 'L', 3, [195], 9, 4, 1, 30;...
                            103, 'E', 1, [205], 11, 2, 1, 500;...
                            103, 'G', 2, [205], 11, 2, 1, 30;...
                            104, 'L', 3, [205], 11, 4, 1, 30;...
                            105, 'V3', 1, [11 128], 3, 2, 2, 500;...
                            105, 'V4', 1, [11 128], 5, 2, 2, 500;...
                            106, 'CDE0', 3, [253], 7, 4, 1, 30;...
                            106, 'CDE1', 3, [253], 7, 4, 1, 30;...
                            106, 'CDE2', 3, [253], 7, 4, 1, 30;...
                            106, 'CDE3', 3, [253], 7, 4, 1, 30;...
                            106, 'CDE4', 3, [253], 7, 4, 1, 30;...
                            106, 'CDE5', 3, [253], 7, 4, 1, 30;...
                            106, 'CDE7', 3, [253], 7, 4, 1, 30;...
                            106, 'CDU0', 3, [253], 7, 4, 1, 30;...
                            106, 'CDU1', 3, [253], 7, 4, 1, 30;...
                            106, 'CDU2', 3, [253], 7, 4, 1, 30;...
                            106, 'CDU3', 3, [253], 7, 4, 1, 30;...
                            106, 'CDU4', 3, [253], 7, 4, 1, 30;...
                            106, 'CDU5', 3, [253], 7, 4, 1, 30;...
                            106, 'PDE0', 3, [253], 7, 4, 1, 30;...
                            106, 'PDE1', 3, [253], 7, 4, 1, 30;...
                            106, 'PDE2', 3, [253], 7, 4, 1, 30;...
                            106, 'PDE3', 3, [253], 7, 4, 1, 30;...
                            106, 'PDE4', 3, [253], 7, 4, 1, 30;...
                            106, 'PDE5', 3, [253], 7, 4, 1, 30;...
                            106, 'PDU0', 3, [253], 7, 4, 1, 30;...
                            106, 'PDU1', 3, [253], 7, 4, 1, 30;...
                            106, 'PDU2', 3, [253], 7, 4, 1, 30;...
                            106, 'PDU3', 3, [253], 7, 4, 1, 30;...
                            107, 'M1', 3, [116], 11, 4, 1, 30;...
                            107, 'M2', 3, [116], 11, 4, 1, 30;...
                            107, 'M3', 3, [116], 11, 4, 1, 30;...
                            107, 'M4', 3, [116], 11, 4, 1, 30;...
                            107, 'M5', 3, [116], 11, 4, 1, 30;...
                            107, 'M6', 3, [116], 11, 4, 1, 30;...
                            107, 'M7', 3, [116], 11, 4, 1, 30;...
                            108, '1', 1, [107], 5, 3, 1, 500;...
                            108, '2', 2, [107], 5, 2, 1, 30;...
                            108, '3', 2, [107], 5, 2, 1, 30;...
                            108, '4', 2, [107], 5, 2, 1, 30;...
                            108, '5', 2, [107], 5, 2, 1, 30;...
                            108, '6', 2, [107], 5, 2, 1, 30;...
                            108, '7', 2, [107], 5, 2, 1, 30;...
                            108, '8', 2, [107], 5, 2, 1, 30;...
                            108, '9', 2, [107], 5, 2, 1, 30;...
                            109, '5', 1, [33 77 101], 9, 2, 2, 500;...
                            110, '30', 1, [50], 7, 2, 2, 500;...
                            110, '30', 1, [50], 9, 2, 2, 500;...
                            111, 'V1', 1, [282], 1, 2, 2, 500;...
                            111, 'V2', 1, [7], 1, 2, 2, 500;...
                            112, '1', 3, [20 142 159 267], 9, 4, 2, 30;...
                            113, '1', 1, [20 133 142 159], 9, 2, 1, 500;...
                            113, '2', 2, [20 133 142 159], 9, 2, 1, 30;...
                            114, '3', 1, [115 250], 9, 2, 1, 500;...
                            114, 'g3', 2, [115 250], 9, 2, 1, 30;...
                            115, 'L4', 3, [115 250], 9, 4, 2, 30;...
                            116, '1', 1, [40], 14, 2, 2, 50;...
                            117, 'E', 1, [22 70 166 176 238 249], 14, 2, 1, 50;...
                            118, 'L', 3, [67 136], 11, 4, 1, 30;...
                            119, 'E', 1, [136], 11, 2, 1, 500;...
                            119, 'G', 2, [136], 11, 2, 1, 30;...
                            120, '3', 1, [8 138], 14, 2, 1, 50;...
                            121, '4', 1, [219 236], 9, 2, 1, 500;...
                            121, '4_Gy', 2, [60 219 236], 9, 2, 1, 30;...
                            122, '1', 3, [86], 14, 2, 1, 50;...
                            123, '1', 1, [86 263], 9, 2, 1, 500;...
                            123, '2', 2, [86 263], 9, 2, 1, 30;...
                            124, '1', 1, [180], 14, 2, 1, 50;...
                            124, '2', 3, [180], 14, 2, 1, 50;...
                            125, 'HV', 1, [88 239], 9, 2, 1, 500;...
                            125, 'HV_1', 2, [88 239], 9, 2, 1, 30;...
                            126, 'HV', 3, [203], 9, 4, 2, 30;...
                            127, '1', 1, [86], 14, 2, 2, 50;...
                            128, '1', 1, [86], 14, 1, 1, 50;...
                            128, '2', 3, [86], 14, 1, 1, 50;...
                            129, 'SzE', 1, [202], 11, 2, 1, 500;...
                            129, 'SZG', 2, [202], 11, 2, 1, 30;...
                            130, '1', 1, [196], 7, 2, 1, 500;...
                            130, '2', 2, [196], 7, 2, 1, 30;...
                            131, 'kg1', 1, [12], 9, 2, 1, 500;...
                            132, '1', 1, [124 240], 14, 2, 2, 50;...
                            133, 'A8', 1, [261], 7, 2, 2, 500;...
                            133, 'A8', 1, [261], 9, 2, 2, 500;...
                            134, 'HV', 1, [28], 14, 2, 1, 50;...
                            135, 'SZE', 1, [46 179], 9, 2, 1, 500;...
                            135, 'SZG', 2, [46 179], 9, 2, 1, 30;...
                            136, 'SZL', 3, [46 80 82 200], 9, 4, 2, 30;...
                            137, 'E', 1, [105 163], 14, 2, 1, 50;...
                            137, 'L', 3, [105 163], 14, 2, 1, 50;...
                            138, '6', 1, [34], 11, 2, 1, 500;...
                            138, '7', 2, [34], 11, 2, 1, 30;...
                            139, '9', 1, [264], 7, 2, 1, 500;...
                            139, '9', 1, [264], 9, 2, 1, 500;...
                            140, '3', 1, [138], 14, 2, 2, 50;...
                            142, '96', 2, [10 64], 12, 2, 1, 30;...
                            142, '97', 2, [10 64], 12, 2, 1, 30;...
                            142, '98', 2, [10 64], 12, 2, 1, 30;...
                            142, '99', 2, [10 64], 12, 2, 1, 30;...
                            142, '100', 2, [10 64], 12, 2, 1, 30;...
                            142, '101', 2, [10 64], 12, 2, 1, 30;...
                            142, '102', 2, [10 64], 12, 2, 1, 30;...
                            142, '103', 2, [10 64], 12, 2, 1, 30;...
                            142, '104', 2, [10 64], 12, 2, 1, 30;...
                            142, '105', 2, [10 64], 12, 2, 1, 30;...
                            142, '106', 2, [10 64], 12, 2, 1, 30;...
                            142, '107', 2, [10 64], 12, 2, 1, 30;...
                            142, '108', 2, [10 64], 12, 2, 1, 30;...
                            142, '109', 2, [10 64], 12, 2, 1, 30;...
                            142, '110', 2, [10 64], 12, 2, 1, 30;...
                            142, '111', 2, [10 39 64], 12, 2, 1, 30;...
                            142, '112', 2, [], 12, 2, 1, 30;...
                            142, '113', 2, [], 12, 2, 1, 30;...
                            142, '114', 2, [], 12, 2, 1, 30;...
                            142, '115', 2, [], 12, 2, 1, 30;...
                            142, 'EA', 1, [10 39 64], 12, 2, 2, 300;...
                            141, 'hszkterem', 2, [46 153], 10, 2, 1, 30;...
                            141, 'KE', 1, [46 153], 10, 3, 1, 300;...
                            141, 'KG', 2, [46 153], 10, 2, 1, 30;...
                            143, 'E', 1, [151], 8, 2, 2, 300;...
                            143, 'G', 2, [151], 8, 2, 1, 30;...
                            143, 'G1', 2, [157], 8, 2, 1, 30;...
                            143, 'G2', 2, [141], 8, 2, 1, 30;...
                            144, 'KeE', 1, [113 230], 12, 2, 1, 300;...
                            144, 'KeG', 2, [113 230], 12, 2, 1, 30;...
                            145, 'E', 1, [105 108], 7, 2, 1, 500;...
                            145, 'G', 2, [105 108], 7, 2, 1, 30;...
                            146, 'L', 3, [22 108 134 163 274], 14, 4, 1, 50;...
                            146, 'L2', 3, [22 108 134 163 274], 14, 4, 1, 50;...
                            147, '1', 1, [251], 7, 2, 1, 500;...
                            147, '1', 1, [251], 9, 2, 1, 500;...
                            148, '1', 1, [44], 14, 2, 1, 50;...
                            148, '2', 2, [44], 14, 2, 1, 50;...
                            149, '1', 1, [72 170], 14, 2, 1, 50;...
                            149, '2', 2, [72 170], 14, 2, 1, 50;...
                            150, 'ra1', 3, [202], 7, 2, 1, 30;...
                            150, 'ra2', 3, [202], 7, 2, 1, 30;...
                            151, 'L1', 3, [110], 3, 2, 2, 30;...
                            151, 'L2', 3, [110], 3, 2, 1, 30;...
                            151, 'L3', 3, [110], 3, 2, 2, 30;...
                            151, 'L4', 3, [110], 3, 2, 1, 30;...
                            152, '13', 3, [54 177 269], 11, 2, 1, 30;...
                            152, '14', 3, [54 177 269], 11, 2, 1, 30;...
                            152, '15', 3, [54 177 269], 11, 2, 1, 30;...
                            152, '16', 3, [54 177 269], 11, 2, 1, 30;...
                            152, '17', 3, [54 177], 11, 2, 1, 30;...
                            153, 'ME5', 1, [13 44], 7, 3, 1, 500;...
                            153, 'MGY7', 2, [13 44], 7, 2, 1, 30;...
                            153, 'MGY8', 2, [13 44], 7, 2, 1, 30;...
                            153, 'MGY9', 2, [13 44], 7, 2, 1, 30;...
                            154, '4', 1, [117], 14, 2, 1, 50;...
                            155, 'I01', 2, [287], 3, 2, 1, 30;...
                            155, 'I02', 2, [45], 3, 2, 1, 30;...
                            155, 'I03', 2, [218], 3, 2, 1, 30;...
                            155, 'I04', 2, [285], 3, 2, 1, 30;...
                            155, 'I05', 2, [102], 3, 2, 1, 30;...
                            155, 'I06', 2, [26], 3, 2, 1, 30;...
                            155, 'I07', 2, [16], 3, 2, 1, 30;...
                            155, 'I08', 2, [209], 3, 2, 1, 30;...
                            155, 'I09', 2, [190], 3, 2, 1, 30;...
                            155, 'I10', 2, [222], 3, 2, 1, 30;...
                            155, 'I11', 2, [1], 3, 2, 1, 30;...
                            155, 'I12', 2, [129], 3, 2, 1, 30;...
                            155, 'I13', 2, [171], 3, 2, 1, 30;...
                            155, 'I14', 2, [130], 3, 2, 1, 30;...
                            155, 'I15', 2, [244], 3, 2, 1, 30;...
                            155, 'I16', 2, [178], 3, 2, 1, 30;...
                            155, 'I17', 2, [262], 3, 2, 1, 30;...
                            155, 'I18', 2, [249], 3, 2, 1, 30;...
                            155, 'V01', 2, [235], 1, 2, 1, 30;...
                            155, 'V02', 2, [185], 1, 2, 1, 30;...
                            155, 'V03', 2, [233], 1, 2, 1, 30;...
                            155, 'V04', 2, [201], 1, 2, 1, 30;...
                            155, 'V05', 2, [163 164], 1, 2, 1, 30;...
                            155, 'V06', 2, [141], 1, 2, 1, 30;...
                            155, 'V07', 2, [144], 1, 2, 1, 30;...
                            155, 'V08', 2, [156], 1, 2, 1, 30;...
                            155, 'V09', 2, [155], 1, 2, 1, 30;...
                            155, 'V10', 2, [225], 1, 2, 1, 30;...
                            155, 'V11', 2, [127], 1, 2, 1, 30;...
                            155, 'V12', 2, [135], 1, 2, 1, 30;...
                            155, 'V13', 2, [252], 1, 2, 1, 30;...
                            155, 'V14', 2, [9], 1, 2, 1, 30;...
                            155, 'V15', 2, [192], 1, 2, 1, 30;...
                            156, 'I01', 2, [23], 7, 2, 1, 30;...
                            156, 'I02', 2, [277], 7, 2, 1, 30;...
                            156, 'I03', 2, [51], 7, 2, 1, 30;...
                            156, 'I04', 2, [253], 7, 2, 1, 30;...
                            156, 'I05', 2, [254], 7, 2, 1, 30;...
                            156, 'I06', 2, [254], 7, 2, 1, 30;...
                            156, 'I07', 2, [253], 7, 2, 1, 30;...
                            156, 'I08', 2, [2], 7, 2, 1, 30;...
                            156, 'I09', 2, [171], 7, 2, 1, 30;...
                            156, 'I10', 2, [218], 7, 2, 1, 30;...
                            156, 'I11', 2, [26], 7, 2, 1, 30;...
                            156, 'I12', 2, [145], 7, 2, 1, 30;...
                            156, 'I13', 2, [2], 7, 2, 1, 30;...
                            156, 'I14', 2, [9], 7, 2, 1, 30;...
                            156, 'I15', 2, [163 164], 7, 2, 1, 30;...
                            156, 'I16', 2, [163 164], 7, 2, 1, 30;...
                            156, 'I17', 2, [25], 7, 2, 1, 30;...
                            156, 'I18', 2, [210], 7, 2, 1, 30;...
                            156, 'I19', 2, [221], 7, 2, 1, 30;...
                            156, 'I20', 2, [50], 7, 2, 1, 30;...
                            156, 'I21', 2, [183], 7, 2, 1, 30;...
                            156, 'V01', 2, [262], 5, 2, 1, 30;...
                            156, 'V02', 2, [197], 5, 2, 1, 30;...
                            156, 'V03', 2, [70], 5, 2, 1, 30;...
                            156, 'V04', 2, [144], 5, 2, 1, 30;...
                            156, 'V05', 2, [159], 5, 2, 1, 30;...
                            156, 'V06', 2, [150], 5, 2, 1, 30;...
                            156, 'V07', 2, [235], 5, 2, 1, 30;...
                            156, 'V08', 2, [181], 5, 2, 1, 30;...
                            156, 'V09', 2, [265], 5, 2, 1, 30;...
                            156, 'V10', 2, [24], 5, 2, 1, 30;...
                            156, 'V11', 2, [243], 5, 2, 1, 30;...
                            156, 'V12', 2, [181 243], 5, 2, 1, 30;...
                            156, 'V13', 2, [168], 5, 2, 1, 30;...
                            156, 'V14', 2, [273], 5, 2, 1, 30;...
                            156, 'V15', 2, [173], 5, 2, 1, 30;...
                            156, 'V16', 2, [229], 5, 2, 1, 30;...
                            156, 'V17', 2, [227], 5, 2, 1, 30;...
                            156, 'V18', 2, [137], 5, 2, 1, 30;...
                            157, '4', 1, [207 262], 11, 2, 1, 500;...
                            157, '5', 2, [207 262], 11, 2, 1, 30;...
                            158, '3', 3, [5], 9, 4, 2, 30;...
                            159, '5', 1, [209 259], 11, 3, 1, 500;...
                            159, '5_Gy', 2, [209 259], 11, 4, 1, 30;...
                            160, 'VIK Info', 2, [], 3, 2, 1, 30;...
                            160, 'VIK Vill.', 2, [], 1, 2, 1, 30;...
                            161, 'VIK Info', 2, [], 7, 2, 1, 30;...
                            161, 'VIK Vill.', 2, [], 5, 2, 1, 30;...
                            162, '1', 1, [159 230], 14, 2, 2, 50;...
                            163, 'HV', 1, [6 28 42 109 146], 14, 2, 2, 50;...
                            164, 'V8', 1, [224 278], 9, 2, 1, 500;...
                            164, 'V9', 1, [224 278], 9, 2, 1, 500;...
                            165, '5', 1, [209 259], 11, 2, 1, 500;...
                            165, '5_Gy', 2, [209 259], 11, 1, 1, 30;...
                            166, '1', 1, [182], 8, 2, 2, 300;...
                            166, '11', 2, [266], 8, 2, 1, 30;...
                            166, '12', 2, [266], 8, 2, 1, 30;...
                            166, '13', 2, [220], 8, 2, 1, 30;...
                            166, '14', 2, [268], 8, 2, 1, 30;...
                            166, '15', 2, [220], 8, 2, 1, 30;...
                            166, '16', 2, [266], 8, 2, 1, 30;...
                            166, '17', 2, [220], 8, 2, 1, 30;...
                            166, '18', 2, [268], 8, 2, 1, 30;...
                            166, '19', 2, [268], 8, 2, 1, 30;...
                            166, '20', 2, [182], 8, 2, 1, 30;...
                            167, '1', 1, [186 237 283], 14, 2, 2, 50;...
                            168, '2010_m_ea', 1, [24 276], 5, 2, 2, 500;...
                            168, '2010_m_gy_01', 2, [24 201 276], 5, 2, 1, 30;...
                            168, '2010_m_gy_02', 2, [24 185 276], 5, 2, 1, 30;...
                            168, '2010_m_gy_03', 2, [24 231 276], 5, 2, 1, 30;...
                            168, '2010_m_gy_04', 2, [24 233 276], 5, 2, 1, 30;...
                            168, '2010_m_gy_05', 2, [24 131 276], 5, 2, 1, 30;...
                            168, '2010_m_gy_06', 2, [24 131 276], 5, 2, 1, 30;...
                            168, '2010_m_gy_07', 2, [24 201 276], 5, 2, 1, 30;...
                            168, '2010_m_gy_08', 2, [24 185 276], 5, 2, 1, 30;...
                            168, '2010_m_gy_09', 2, [24 231 276], 5, 2, 1, 30;...
                            168, '2010_m_gy_10', 2, [24 276], 5, 2, 1, 30;...
                            168, '2010_m_l_01', 3, [24 231 276], 5, 4, 1, 30;...
                            168, '2010_m_l_02', 3, [24 231], 5, 4, 1, 30;...
                            168, '2010_m_l_03', 3, [24 231 276], 5, 4, 1, 30;...
                            168, '2010_m_l_04', 3, [24 231 276], 5, 4, 1, 30;...
                            169, '6', 3, [231 252], 9, 4, 1, 30;...
                            169, '07a', 3, [75 149 231 252], 9, 3, 1, 30;...
                            170, '1', 1, [48 185], 14, 2, 2, 50;...
                            171, '9', 1, [117 281], 9, 2, 1, 500;...
                            171, '10', 2, [117 281], 9, 2, 1, 30;...
                            172, '9', 1, [75], 9, 2, 1, 500;...
                            172, '10', 2, [75], 9, 2, 1, 30;...
                            173, '3', 1, [24], 14, 2, 1, 50;...
                            174, '1', 1, [17 216], 14, 2, 1, 50;...
                            175, '9', 1, [131 247], 9, 2, 1, 500;...
                            175, '10', 2, [131 247], 9, 2, 1, 30;...
                            176, '1', 1, [17], 14, 2, 2, 50;...
                            177, '9', 1, [194], 14, 2, 1, 50;...
                            178, '1', 1, [3 44], 14, 2, 1, 50;...
                            178, '2', 2, [3 44], 14, 2, 1, 50;...
                            179, '1', 2, [], 3, 2, 1, 30;...
                            179, '2', 2, [], 3, 2, 1, 30;...
                            179, '3', 2, [], 7, 2, 1, 30;...
                            179, '4', 2, [], 11, 2, 1, 30;...
                            179, '5', 2, [], 5, 2, 1, 30;...
                            179, '6', 2, [], 1, 2, 1, 30;...
                            179, '7', 2, [], 7, 2, 1, 30;...
                            179, '8', 2, [], 1, 2, 1, 30;...
                            179, '9', 2, [], 5, 2, 1, 30;...
                            179, '10', 2, [], 7, 2, 2, 30;...
                            179, '11', 2, [], 5, 2, 1, 30;...
                            179, '12', 2, [], 11, 2, 1, 30;...
                            179, '13', 2, [], 9, 2, 1, 30;...
                            179, '14', 2, [], 9, 2, 1, 30;...
                            180, '1', 1, [37 107], 14, 2, 2, 50};

            % Terem(Terem neve, plet ID, Frhelyek szma, Alkalmas labornak?, Tanszk ID)
            fp.classroom = {'CHFMAX', 1, 300, 0, 0;...
                            'E1A', 2, 200, 0, 0;...
                            'E1B', 2, 500, 0, 0;...
                            'E1C', 2, 200, 0, 0;...
                            'E602', 2, 50, 0, 0;...
                            'E602b', 2, 50, 0, 0;...
                            'E701', 2, 20, 0, 0;...
                            'E702', 2, 20, 0, 0;...
                            'E703', 2, 20, 0, 0;...
                            'E704', 2, 20, 0, 0;...
                            'E705', 2, 20, 0, 0;...
                            'F229', 3, 300, 0, 0;...
                            'F2E', 3, 200, 0, 0;...
                            'H405A', 4, 50, 0, 0;...
                            'H406', 4, 50, 0, 0;...
                            'H507', 4, 50, 0, 0;...
                            'IB025', 5, 200, 0, 0;...
                            'IB026', 5, 200, 0, 0;...
                            'IB027', 5, 200, 0, 0;...
                            'IB028', 5, 500, 0, 0;...
                            'IB138', 5, 30, 0, 0;...
                            'IB139', 5, 30, 0, 0;...
                            'IB140', 5, 30, 0, 0;...
                            'IB141', 5, 30, 0, 0;...
                            'IB142', 5, 30, 0, 0;...
                            'IB143', 5, 30, 0, 0;...
                            'IB144', 5, 30, 0, 0;...
                            'IB145', 5, 30, 0, 0;...
                            'IB146', 5, 30, 0, 0;...
                            'IB310', 5, 20, 0, 0;...
                            'IB410', 5, 20, 0, 0;...
                            'IE007', 5, 300, 0, 0;...
                            'IE213', 5, 50, 0, 0;...
                            'IE215', 5, 50, 0, 0;...
                            'IE216', 5, 50, 0, 0;...
                            'IE217', 5, 50, 0, 0;...
                            'IE218', 5, 50, 0, 0;...
                            'IE219', 5, 50, 0, 0;...
                            'IE220', 5, 100, 0, 0;...
                            'IE504', 5, 30, 1, 0;...
                            'K121', 6, 100, 0, 0;...
                            'K140', 6, 100, 0, 0;...
                            'K148', 6, 100, 0, 0;...
                            'K240', 6, 100, 0, 0;...
                            'K264', 6, 100, 0, 0;...
                            'K331', 6, 100, 0, 0;...
                            'K339', 6, 100, 0, 0;...
                            'K341', 6, 100, 0, 0;...
                            'KA26', 6, 100, 0, 0;...
                            'KA51', 6, 100, 0, 0;...
                            'KAAUD', 6, 600, 0, 0;...
                            'R3R', 7, 20, 1, 0;...
                            'R3S', 7, 20, 1, 0;...
                            'R3T', 7, 20, 1, 0;...
                            'R3U', 7, 20, 1, 0;...
                            'R4A', 7, 20, 1, 0;...
                            'R4B', 7, 20, 1, 0;...
                            'R4C', 7, 20, 1, 0;...
                            'R4D', 7, 20, 1, 0;...
                            'R4E', 7, 20, 1, 0;...
                            'R4I', 7, 20, 1, 0;...
                            'R4J', 7, 20, 1, 0;...
                            'R4K', 7, 20, 1, 0;...
                            'R4L', 7, 20, 1, 0;...
                            'R4M', 7, 20, 1, 0;...
                            'R4N', 7, 20, 1, 0;...
                            'R4O', 7, 20, 1, 0;...
                            'R4P', 7, 20, 1, 0;...
                            'R501', 7, 30, 0, 0;...
                            'R504', 7, 30, 0, 0;...
                            'R505', 7, 30, 0, 0;...
                            'R506', 7, 30, 0, 0;...
                            'R507', 7, 30, 0, 0;...
                            'R508', 7, 30, 0, 0;...
                            'R513', 7, 30, 0, 0;...
                            'R514', 7, 30, 0, 0;...
                            'R515', 7, 30, 0, 0;...
                            'R516', 7, 30, 0, 0;...
                            'R517', 7, 30, 0, 0;...
                            'ST205', 8, 50, 0, 0;...
                            'ST220-21', 8, 50, 0, 0;...
                            'STFNAGY', 8, 500, 0, 0;...
                            'T603', 9, 30, 0, 0;...
                            'T604', 9, 30, 0, 0;...
                            'T605', 9, 30, 0, 0;...
                            'T606', 9, 30, 0, 0;...
                            'V1100', 10, 30, 0, 0;...
                            'V1213', 10, 30, 0, 0;...
                            'V1405', 10, 30, 0, 0;...
                            'V1406', 10, 30, 0, 0;...
                            'V1407', 10, 30, 0, 0;...
                            'V1408', 10, 30, 0, 0;...
                            'V1409', 10, 30, 0, 0;...
                            'V1502', 10, 30, 0, 0;...
                            'V2033', 11, 30, 0, 0;...
                            'V2225', 11, 30, 0, 0;...
                            'V2317', 11, 30, 0, 0;...
                            'V2323', 11, 30, 0, 0;...
                            'V2357', 11, 30, 0, 0;...
                            'V2357', 11, 30, 0, 0;...
                            'V2504', 11, 30, 0, 0;...
                            'V2518', 11, 30, 0, 0;...
                            'V2520', 11, 30, 0, 0;...
                            'V2530', 11, 30, 0, 0;...
                            'V2601', 11, 30, 0, 0;...
                            'V2628A', 11, 30, 0, 0;...
                            'V2704', 11, 30, 0, 0;...
                            'V2705', 11, 30, 0, 0;...
                            'V2706', 11, 30, 0, 0;...
                            'V2707', 11, 30, 0, 0;...
                            'V2716', 11, 30, 0, 0;...
                            'V2719', 11, 30, 0, 0;...
                            'V2720', 11, 30, 0, 0;...
                            'Z105', 12, 30, 0, 0;...
                            'Z203', 12, 30, 0, 0;...
                            'Z205', 12, 30, 0, 0;...
                            'Z208', 12, 30, 0, 0;...
                            'ZF04', 12, 30, 0, 0;...
                            'AUT-LABOR', 5, 25, 1, 1;...
                            'AUT-TEREM', 5, 30, 0, 1;...
                            'EET-LABOR', 11, 25, 1, 2;...
                            'EET-TEREM', 11, 30, 0, 2;...
                            'ETT-LABOR', 11, 25, 1, 3;...
                            'ETT-TEREM', 11, 30, 0, 3;...
                            'HIT-LABOR', 5, 25, 1, 4;...
                            'HIT-TEREM', 5, 30, 0, 4;...
                            'HVT-LABOR', 11, 25, 1, 5;...
                            'HVT-TEREM', 11, 30, 0, 5;...
                            'IIT-LABOR', 5, 25, 1, 6;...
                            'IIT-TEREM', 5, 30, 0, 6;...
                            'MIT-LABOR', 5, 25, 1, 7;...
                            'MIT-TEREM', 5, 30, 0, 7;...
                            'SZIT-LABOR', 5, 25, 1, 8;...
                            'SZIT-TEREM', 5, 30, 0, 8;...
                            'TMIT-LABOR', 5, 25, 1, 9;...
                            'TMIT-TEREM', 5, 30, 0, 9;...
                            'VET-LABOR', 10, 25, 1, 10;...
                            'VET-TEREM', 10, 30, 0, 10};

            % Kezdsi idpontok(Nap ID, Kezds rja)
            % Megj.: kezds mindig negyedkor, befejezs egszkor
            fp.starttime = [1, 8;...
                            1, 9;...
                            1, 10;...
                            1, 11;...
                            1, 12;...
                            1, 13;...
                            1, 14;...
                            1, 15;...
                            1, 16;...
                            1, 17;...
                            1, 18;...
                            2, 8;...
                            2, 9;...
                            2, 10;...
                            2, 11;...
                            2, 12;...
                            2, 13;...
                            2, 14;...
                            2, 15;...
                            2, 16;...
                            2, 17;...
                            2, 18;...
                            3, 8;...
                            3, 9;...
                            3, 10;...
                            3, 11;...
                            3, 12;...
                            3, 13;...
                            3, 14;...
                            3, 15;...
                            3, 16;...
                            3, 17;...
                            3, 18;...
                            4, 8;...
                            4, 9;...
                            4, 10;...
                            4, 11;...
                            4, 12;...
                            4, 13;...
                            4, 14;...
                            4, 15;...
                            4, 16;...
                            4, 17;...
                            4, 18;...
                            5, 8;...
                            5, 9;...
                            5, 10;...
                            5, 11;...
                            5, 12;...
                            5, 13;...
                            5, 14;...
                            5, 15;...
                            5, 16;...
                            5, 17;...
                            5, 18];

    end
    
    % Set the domain of gene values to a discrete interval
    genes.domain   	= [1, size(fp.starttime, 1)*size(fp.classroom, 1)];
    genes.discrete  = true;

    % Set the length of chromosomes to encode the starting time of all the LECTURES
    chr_length      = sum(cell2mat(fp.course(:,7)));

    % Initialize the lecture-course index (to a given length (to save memory and runtime))
    fp.lecture      = zeros(chr_length, 2);

    % Initialize the lectureID
    k               = 1;

    % Elads(Kurzus ID, Hossz, Hallgatk szma)
    for i=1:size(fp.course, 1),

        % For all the lectures of the i-th course do...
        for j=1:fp.course{i, 7},

           % Set the courseID of the lecture
           fp.lecture(k, 1) = i;

           % Set the length of the lecture
           fp.lecture(k, 2) = fp.course{i, 6};
           
           % Set the number of students on the lecture
           fp.lecture(k, 3) = fp.course{i, 8};

           % Increase the lectureID
           k = k + 1;

        end

    end

catch
   
	% Catch and display the last error or an exception thrown above
	err = lasterror;
	disp(err.message);
   
end