function B = repcols(A, colnum)
% -------------------------------------------------
% CLASSICAL GENETIC ALGORITHM
% repcols - replicate the columns of matrix A
%           a given number of times
%
% A         - arbitrary 2D matrix
% colnum	- a row vector with the same number of
%             columns as A. Every element
%             represents the desired number of
%             repetitions of the corresponding
%             column of A
%
% Made by:
% Daniel L. Kovacs
% <dkovacs@mit.bme.hu>
%
% Department of Measurement and Information Systems
% Faculty of Electrical Engineering and Informatics
% Budapest University of Technology and Economics
% 
% March 2010
% -------------------------------------------------

try
    
    % No input testing for performance reasons here, BUT:
    % size(A,2) = size(colnum,2) AND
    % the elements of colnum should be integers AND
    % min(colnum) >= 0
    
    p      	= cumsum(colnum) + 1;          	% Where does the next column start?
    idx    	= zeros(1, p(end));           	% Initialize the index vector
    idx(p) 	= 1;                            % Set the next-column-positions to 1
    B       = A(:, cumsum(idx(1:end-1))+1); % The cumsum here is creating the "steps" (00111223333444...) in the shortened index vector
                                            % The length of these "steps" was effectively given in the input colnum...

catch
   
	% Catch and display the last error or an exception thrown above
	err = lasterror;
	disp(err.message);
   
end