function pair = selection(pop, fvals)
% -------------------------------------------------
% CLASSICAL GENETIC ALGORITHM
% selection - roulette-wheel type selection
%
% Made by:
% Daniel L. Kovacs
% <dkovacs@mit.bme.hu>
%
% Department of Measurement and Information Systems
% Faculty of Electrical Engineering and Informatics
% Budapest University of Technology and Economics
% 
% January 2010
% -------------------------------------------------

try
    
    % Initialize output variables
    pair = [];

	% -----------------------------------------------------------------------------------------------------------------------------
    % -------------------------------------------------------- INPUT CHECK --------------------------------------------------------
    % -----------------------------------------------------------------------------------------------------------------------------
    
    % Check input variable 1/2
	if  isempty(pop),                             	% IF the population (pop) is empty, THEN...
       
        throw(MException('MATLAB:selection:pop',...
                         'Input error (1/2): the population should not be empty'));
        
	end
    
    % Check input variable 2/2
	if  size(fvals, 1) ~= size(pop, 1) ||...        % IF there are more/less fitness values than individuals, OR...
        size(fvals, 2) ~= 1,                        % fvals isn't a column vector, THEN...
       
        throw(MException('MATLAB:selection:fvals',...
                         'Input error (2/2): there should be as many fitness values (in a column vector) as many individuals in the population'));
        
	end
    
    % --------------------------------------------------------------------------------------------------------------------------------
    % -------------------------------------------------------- FUNCTION BODY  --------------------------------------------------------
    % --------------------------------------------------------------------------------------------------------------------------------
    
    % Create the roulette wheel, i.e. first normalize the fitness values, then add them up cumulatively
    roulettewheel   = cumsum(fvals./sum(fvals));
    
    % Choose the two lucky individuals (parents), i.e. turn the wheel, and
    % check in which individual's roulette section the ball stops (i.e. generate a random number between 0 and 1, and
    % check which is the first element of the roulette wheel, which is
    % greater or equal than that random number
    pair(1, :)      = pop(find(roulettewheel >= rand, 1), :);
    pair(2, :)      = pop(find(roulettewheel >= rand, 1), :);
        
catch
   
	% Catch and display the last error or an exception thrown above
	err = lasterror;
	disp(err.message);
   
end