function [y] = simnet(net, p)
% -------------------------------------------------
% CLASSICAL GENETIC ALGORITHM
% simnet - calculate the outputs of a feed-forward
%          neural network from the Neural Network
%          Toolbox (v6)     [faster than nnet/sim]
%
% Made by:
% Daniel L. Kovacs
% <dkovacs@mit.bme.hu>
%
% Department of Measurement and Information Systems
% Faculty of Electrical Engineering and Informatics
% Budapest University of Technology and Economics
% 
% January 2010
% -------------------------------------------------

try
    
    z  	= ones(1, size(p, 2));
    y 	= tansig([net.IW{1, 1}, net.b{1}] * [p; z]);
    for i=2:net.numLayers-1, y	= tansig([net.LW{i, i-1}, net.b{i}] * [y; z]); end
    y	= [net.LW{net.numLayers, net.numLayers-1}, net.b{net.numLayers}] * [y; z];
    
    % THERE IS A DIFFERENCE BETWEEN THE OUTPUT OF THIS FUNCTION AND
    % NNET.SIM BECAUSE THE LATTER PRE/POST-PROCESSES THE OUTPUTS: processoutputs(net, y) 
    %
    % ----------------------------------------------------------------------
    % sim(net, p) == processoutputs(net, simnet(net, processinputs(net, p)))
    % ----------------------------------------------------------------------
    %
    % See. net.inputs{1}.processSettings AND net.outputs{...}.processSettings 
catch
   
	% Catch and display the last error or an exception thrown above
	err = lasterror;
	disp(err.message);
   
end