//******************************************************************************
//* LOGSYS SD card bootloader settings.                                        *
//* Written by   : Tamas Raikovich                                             *
//* Version      : 1.0                                                         *
//* Last modified: 2013.10.26.                                                 *
//******************************************************************************
#ifndef SETTINGS_H_
#define SETTINGS_H_

#include <xparameters.h>


//******************************************************************************
//* Settings related to the boot image file.                                   *
//******************************************************************************
//Full path of the boot image file.
#define BOOTIMAGE_NAME		"/BOOTIMG/LINSP6BE.BIN"
//Start address where the boot image file is loaded to.
#define START_ADDRESS		XPAR_SDRAM_MEM_BASEADDR


//******************************************************************************
//* Settings related to the interrupt controller.                              *
//******************************************************************************
//Base address.
#define INTC_BASEADDR		XPAR_XPS_INTC_0_BASEADDR


//******************************************************************************
//* Settings related to the timer.                                             *
//******************************************************************************
//Base address.
#define TIMER_BASEADDR		XPAR_XPS_TIMER_0_BASEADDR
//System clock frequency.
#define TIMER_CLKFREQ_HZ	XPAR_PROC_BUS_0_FREQ_HZ
//Interrupt.
#define TIMER_IRQ			XPAR_XPS_INTC_0_XPS_TIMER_0_INTERRUPT_INTR


//******************************************************************************
//* Settings related to the SPI interface.                                     *
//******************************************************************************
//Base address.
#define SPI_BASEADDR		XPAR_LOGSYS_PLB_SPI_IF_0_BASEADDR
//System clock frequency.
#define SPI_CLKFREQ_HZ		XPAR_PROC_BUS_0_FREQ_HZ


#endif /* SETTINGS_H_ */
