////////////////////////////////////////////////////////////////////////////////
/// @file timer.h
/// Header file for the timer functions.
///
/// @author  Tamas Raikovich
/// @version 1.0
/// @date    2012.01.21.
////////////////////////////////////////////////////////////////////////////////
#ifndef TIMER_H_
#define TIMER_H_


////////////////////////////////////////////////////////////////////////////////
/// Number of timer interrupts per second. Can be changed if different timer
/// resolution is required.
////////////////////////////////////////////////////////////////////////////////
#define CLOCK_SECOND        10


////////////////////////////////////////////////////////////////////////////////
/// Timer object structure.
////////////////////////////////////////////////////////////////////////////////
typedef struct _timer
{
	///Value of the timer counter when the timer was started.
    unsigned long start;
    ///Number of ticks after the timer will expire.
    unsigned long interval;
} timer, *ptimer;


////////////////////////////////////////////////////////////////////////////////
///@name Function prototypes.
///@{
////////////////////////////////////////////////////////////////////////////////
void timer_init(unsigned long freq);
void timer_set(ptimer t, unsigned long interval);
void timer_reset(ptimer t);
void timer_restart(ptimer t);
unsigned char timer_expired(ptimer t);
///@}


#endif /* TIMER_H_ */

