/*
 * Copyright (c) 2009 Xilinx, Inc.  All rights reserved.
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION 
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <stdio.h>
#include <xintc_l.h>
#include "xparameters.h"
#include "xil_types.h"
#include "xstatus.h"
#include "xil_testmem.h"
#include "xil_cache.h"

#include "platform.h"
#include "memory_config.h"

#include "timer/timer.h"

void putnum(unsigned int num);
void print(char *ptr);

void test_memory_range(struct memory_range_s *range) {
    XStatus status;

    /* This application uses print statements instead of xil_printf/printf
     * to reduce the text size.
     *
     * The default linker script generated for this application does not have
     * heap memory allocated. This implies that this program cannot use any
     * routines that allocate memory on heap (printf is one such function).
     * If you'd like to add such functions, then please generate a linker script
     * that does allocate sufficient heap memory.
     */

    print("Testing memory region: "); print(range->name);  print("\r\n");
    print("    Memory Controller: "); print(range->ip);  print("\r\n");
    print("         Base Address: 0x"); putnum(range->base); print("\r\n");
    print("                 Size: 0x"); putnum(range->size); print (" bytes \r\n");

    status = Xil_TestMem32((u32*)range->base, range->size >> 2, 0xAAAA5555, XIL_TESTMEM_ALLMEMTESTS);
    print("          32-bit test: "); print(status == XST_SUCCESS? "PASSED!":"FAILED!"); print("\r\n");

    status = Xil_TestMem16((u16*)range->base, range->size >> 1, 0xAA55, XIL_TESTMEM_ALLMEMTESTS);
    print("          16-bit test: "); print(status == XST_SUCCESS? "PASSED!":"FAILED!"); print("\r\n");

    status = Xil_TestMem8((u8*)range->base, range->size, 0xA5, XIL_TESTMEM_ALLMEMTESTS);
    print("           8-bit test: "); print(status == XST_SUCCESS? "PASSED!":"FAILED!"); print("\r\n");

}

int main()
{
    int i;

    unsigned long s, ms;

    init_platform();
    microblaze_enable_interrupts();
    XIntc_MasterEnable(XPAR_INTC_0_BASEADDR);
    timer_init();

    print("--Starting Memory Test Application--\r\n");
    print("NOTE: This application runs with D-Cache disabled.\r\n");
    print("As a result, cacheline requests will not be generated\r\n");

    timer_clear();

    for (i = 0; i < n_memory_ranges; i++) {
        test_memory_range(&memory_ranges[i]);
    }

    timer_get(&s, &ms);
    xil_printf("Elapsed time: %d.%03d s.\r\n", s, ms);

    print("--Memory Test Application Complete--\r\n\r\n");

    Xil_DCacheEnable();

    print("--Starting Memory Test Application--\r\n");
    print("NOTE: This application runs with D-Cache enabled.\r\n");

    timer_clear();

    for (i = 0; i < n_memory_ranges; i++) {
        test_memory_range(&memory_ranges[i]);
    }

    timer_get(&s, &ms);
    xil_printf("Elapsed time: %d.%03d s.\r\n", s, ms);

    print("--Memory Test Application Complete--\r\n\r\n");

    Xil_DCacheDisable();

    return 0;
}
